/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoAssociationPathInverter;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverImpl;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.impl.Closer;

public final class PojoImplicitReindexingResolverBuildingHelper {
    private final ContainerExtractorBinder extractorBinder;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final PojoAssociationPathInverter pathInverter;
    private final Set<PojoRawTypeModel<?>> entityTypes;
    private final ReindexOnUpdate defaultReindexOnUpdate;
    private final Map<PojoRawTypeModel<?>, Set<PojoRawTypeModel<?>>> concreteEntitySubTypesByEntitySuperType = new HashMap();
    private final Map<PojoRawTypeModel<?>, PojoImplicitReindexingResolverBuilder<?>> builderByType = new HashMap();

    public PojoImplicitReindexingResolverBuildingHelper(ContainerExtractorBinder extractorBinder, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider, Set<PojoRawTypeModel<?>> entityTypes, ReindexOnUpdate defaultReindexOnUpdate) {
        this.extractorBinder = extractorBinder;
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
        this.pathInverter = new PojoAssociationPathInverter(typeAdditionalMetadataProvider, extractorBinder);
        this.entityTypes = entityTypes;
        this.defaultReindexOnUpdate = defaultReindexOnUpdate;
        for (PojoRawTypeModel<?> pojoRawTypeModel : entityTypes) {
            if (pojoRawTypeModel.isAbstract()) continue;
            pojoRawTypeModel.ascendingSuperTypes().forEach(superType -> this.concreteEntitySubTypesByEntitySuperType.computeIfAbsent((PojoRawTypeModel<?>)superType, ignored -> new LinkedHashSet()).add(entityType));
        }
        for (Map.Entry entry : this.concreteEntitySubTypesByEntitySuperType.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
    }

    public <T> PojoIndexingDependencyCollectorTypeNode<T> createDependencyCollector(PojoRawTypeModel<T> typeModel) {
        return new PojoIndexingDependencyCollectorTypeNode<T>(typeModel, this);
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(PojoImplicitReindexingResolverBuilder::closeOnFailure, this.builderByType.values());
        }
    }

    public <T, S> PojoImplicitReindexingResolver<T, S> build(PojoRawTypeModel<T> typeModel, PojoPathFilterFactory<S> pathFilterFactory) {
        return this.buildOptional(typeModel, pathFilterFactory).orElseGet(() -> new PojoImplicitReindexingResolverImpl(PojoPathFilter.empty(), PojoImplicitReindexingResolverNode.noOp()));
    }

    public <T, S> Optional<PojoImplicitReindexingResolver<T, S>> buildOptional(PojoRawTypeModel<T> typeModel, PojoPathFilterFactory<S> pathFilterFactory) {
        PojoImplicitReindexingResolverBuilder<?> builder = this.builderByType.get(typeModel);
        if (builder == null) {
            return Optional.empty();
        }
        return builder.build(pathFilterFactory);
    }

    PojoAssociationPathInverter getPathInverter() {
        return this.pathInverter;
    }

    boolean isEntity(PojoRawTypeModel<?> typeModel) {
        return this.entityTypes.contains(typeModel);
    }

    Set<? extends PojoRawTypeModel<?>> getConcreteEntitySubTypesForEntitySuperType(PojoRawTypeModel<?> superTypeModel) {
        return this.concreteEntitySubTypesByEntitySuperType.computeIfAbsent(superTypeModel, ignored -> Collections.emptySet());
    }

    <T> PojoImplicitReindexingResolverBuilder<T> getOrCreateResolverBuilder(PojoRawTypeModel<T> rawTypeModel) {
        PojoImplicitReindexingResolverBuilder<Object> builder = this.builderByType.get(rawTypeModel);
        if (builder == null) {
            builder = new PojoImplicitReindexingResolverBuilder<T>(rawTypeModel, this);
            this.builderByType.put(rawTypeModel, builder);
        }
        return builder;
    }

    ContainerExtractorBinder getExtractorBinder() {
        return this.extractorBinder;
    }

    <V, T> ContainerExtractorHolder<T, V> createExtractors(BoundContainerExtractorPath<T, V> boundExtractorPath) {
        return this.extractorBinder.create(boundExtractorPath);
    }

    ReindexOnUpdate getReindexOnUpdate(ReindexOnUpdate parentReindexOnUpdate, PojoTypeModel<?> typeModel, String propertyName, ContainerExtractorPath extractorPath) {
        if (ReindexOnUpdate.NO.equals((Object)parentReindexOnUpdate)) {
            return ReindexOnUpdate.NO;
        }
        PojoTypeAdditionalMetadata typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(typeModel.rawType());
        Optional<ReindexOnUpdate> reindexOnUpdateOptional = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(extractorPath).getReindexOnUpdate();
        if (!reindexOnUpdateOptional.isPresent() && this.extractorBinder.isDefaultExtractorPath(typeModel.property(propertyName).typeModel(), extractorPath)) {
            reindexOnUpdateOptional = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(ContainerExtractorPath.defaultExtractors()).getReindexOnUpdate();
        }
        return reindexOnUpdateOptional.orElse(this.defaultReindexOnUpdate);
    }

    Set<PojoModelPathValueNode> getDerivedFrom(PojoTypeModel<?> typeModel, String propertyName, ContainerExtractorPath extractorPath) {
        PojoTypeAdditionalMetadata typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(typeModel.rawType());
        Set<PojoModelPathValueNode> derivedFrom = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(extractorPath).getDerivedFrom();
        if (derivedFrom.isEmpty() && this.extractorBinder.isDefaultExtractorPath(typeModel.property(propertyName).typeModel(), extractorPath)) {
            derivedFrom = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(ContainerExtractorPath.defaultExtractors()).getDerivedFrom();
        }
        return derivedFrom;
    }
}

