/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public final class BeanBinder
implements IdentifierBinder,
ValueBinder {
    private final BeanReference<?> beanReference;

    public BeanBinder(BeanReference<?> beanReference) {
        this.beanReference = beanReference;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.beanReference + "]";
    }

    @Override
    public void bind(IdentifierBindingContext<?> context) {
        BeanHolder<IdentifierBridge> bridgeHolder = this.doBuild(context.beanResolver(), IdentifierBridge.class);
        try {
            this.doBind(bridgeHolder, context);
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((IdentifierBridge)holder.get()).close(), bridgeHolder)).push(bridgeHolder);
            throw e;
        }
    }

    @Override
    public void bind(ValueBindingContext<?> context) {
        BeanHolder<ValueBridge> bridgeHolder = this.doBuild(context.beanResolver(), ValueBridge.class);
        try {
            this.doBind(bridgeHolder, context);
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((ValueBridge)holder.get()).close(), bridgeHolder)).push(bridgeHolder);
            throw e;
        }
    }

    private <B extends IdentifierBridge<I>, I> void doBind(BeanHolder<B> bridgeHolder, IdentifierBindingContext<?> context) {
        IdentifierBridge bridge = (IdentifierBridge)bridgeHolder.get();
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(bridge.getClass());
        Class bridgeParameterType = bridgeTypeContext.resolveTypeArgument(IdentifierBridge.class, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the input type for identifier bridge '" + bridge + "'. There is a bug in Hibernate Search, please report it."));
        context.bridge(bridgeParameterType, bridge);
    }

    private <B extends ValueBridge<V, F>, V, F> void doBind(BeanHolder<B> bridgeHolder, ValueBindingContext<?> context) {
        ValueBridge bridge = (ValueBridge)bridgeHolder.get();
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(bridge.getClass());
        Class bridgeParameterType = bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the input type for value bridge '" + bridge + "'. There is a bug in Hibernate Search, please report it."));
        context.bridge(bridgeParameterType, bridge);
    }

    private <T> BeanHolder<? extends T> doBuild(BeanResolver beanResolver, Class<T> expectedType) {
        return this.beanReference.asSubTypeOf(expectedType).resolve(beanResolver);
    }
}

