/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.runtime.impl;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.RoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.RoutingBridgeRouteContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.RoutingKeyBridgeToRoutingKeyContext;
import org.hibernate.search.mapper.pojo.route.DocumentRoutes;
import org.hibernate.search.util.common.impl.Closer;

public class RoutingKeyBridgeRoutingBridgeAdapter<E>
implements RoutingBridge<E> {
    private final BeanHolder<? extends RoutingKeyBridge> bridgeHolder;

    public RoutingKeyBridgeRoutingBridgeAdapter(BeanHolder<? extends RoutingKeyBridge> bridgeHolder) {
        this.bridgeHolder = bridgeHolder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bridgeHolder=" + this.bridgeHolder + "]";
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(holder -> ((RoutingKeyBridge)holder.get()).close(), this.bridgeHolder);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    @Override
    public void route(DocumentRoutes routes, Object entityIdentifier, E indexedEntity, RoutingBridgeRouteContext context) {
        String routingKey = ((RoutingKeyBridge)this.bridgeHolder.get()).toRoutingKey(context.tenantIdentifier(), entityIdentifier, indexedEntity, (RoutingKeyBridgeToRoutingKeyContext)((Object)context));
        routes.addRoute().routingKey(routingKey);
    }

    @Override
    public void previousRoutes(DocumentRoutes routes, Object entityIdentifier, E indexedEntity, RoutingBridgeRouteContext context) {
        this.route(routes, entityIdentifier, indexedEntity, context);
    }
}

