/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.spi.FieldModelContributor;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorCastedTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorValueBridgeNode;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexingProcessorValueNodeBuilderDelegate<P, V>
extends AbstractPojoProcessorNodeBuilder
implements PojoMappingCollectorValueNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BoundPojoModelPathValueNode<?, P, V> modelPath;
    private final Collection<BoundValueBridge<V, ?>> boundBridges = new ArrayList();
    private final Collection<AbstractPojoIndexingProcessorTypeNodeBuilder<V, ?>> typeNodeBuilders = new ArrayList();
    private final boolean multiValuedFromContainerExtractor;

    PojoIndexingProcessorValueNodeBuilderDelegate(BoundPojoModelPathValueNode<?, P, V> modelPath, PojoMappingHelper mappingHelper, IndexBindingContext bindingContext, boolean multiValuedFromContainerExtractor) {
        super(mappingHelper, bindingContext);
        this.modelPath = modelPath;
        this.multiValuedFromContainerExtractor = multiValuedFromContainerExtractor;
    }

    @Override
    public void valueBinder(ValueBinder binder, String relativeFieldName, FieldModelContributor fieldModelContributor) {
        String defaultedRelativeFieldName = relativeFieldName;
        if (defaultedRelativeFieldName == null) {
            defaultedRelativeFieldName = ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().name();
        }
        this.mappingHelper.indexModelBinder().bindValue(this.bindingContext, this.modelPath, this.multiValuedFromContainerExtractor, binder, defaultedRelativeFieldName, fieldModelContributor).ifPresent(this.boundBridges::add);
    }

    @Override
    public void indexedEmbedded(PojoRawTypeModel<?> definingTypeModel, String relativePrefix, ObjectStructure structure, Integer includeDepth, Set<String> includePaths, Class<?> targetType) {
        String defaultedRelativePrefix = relativePrefix;
        if (defaultedRelativePrefix == null) {
            defaultedRelativePrefix = ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().name() + ".";
        }
        IndexedEmbeddedDefinition definition = new IndexedEmbeddedDefinition(definingTypeModel, defaultedRelativePrefix, structure, includeDepth, includePaths);
        Optional nestedBindingContextOptional = this.bindingContext.addIndexedEmbeddedIfIncluded(definition, this.multiValuedFromContainerExtractor);
        nestedBindingContextOptional.ifPresent(nestedBindingContext -> {
            AbstractPojoIndexingProcessorTypeNodeBuilder nestedProcessorBuilder;
            if (targetType == null) {
                nestedProcessorBuilder = new PojoIndexingProcessorOriginalTypeNodeBuilder<V>(this.modelPath.type(), this.mappingHelper, (IndexBindingContext)nestedBindingContext, Optional.empty(), nestedBindingContext.parentIndexObjectReferences());
            } else {
                PojoRawTypeModel castedType = this.mappingHelper.introspector().typeModel(targetType);
                nestedProcessorBuilder = new PojoIndexingProcessorCastedTypeNodeBuilder(this.modelPath.castedType(castedType), this.mappingHelper, (IndexBindingContext)nestedBindingContext, Optional.empty(), nestedBindingContext.parentIndexObjectReferences());
            }
            this.typeNodeBuilders.add(nestedProcessorBuilder);
            PojoTypeModel targetTypeModel = ((BoundPojoModelPathTypeNode)((AbstractPojoIndexingProcessorTypeNodeBuilder)nestedProcessorBuilder).getModelPath()).getTypeModel();
            Set contributors = this.mappingHelper.contributorProvider().get(targetTypeModel.rawType());
            if (contributors.isEmpty()) {
                throw log.invalidIndexedEmbedded(targetTypeModel);
            }
            contributors.forEach(c -> c.contributeMapping(nestedProcessorBuilder));
        });
    }

    @Override
    BoundPojoModelPathValueNode<?, P, V> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(boundBridge -> ((ValueBridge)boundBridge.getBridgeHolder().get()).close(), this.boundBridges);
            closer.pushAll(boundBridge -> boundBridge.getBridgeHolder().close(), this.boundBridges);
            closer.pushAll(AbstractPojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.typeNodeBuilders);
        }
    }

    Collection<PojoIndexingProcessor<? super V>> build(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        try {
            return this.doBuild(parentDependencyCollector);
        }
        catch (RuntimeException e) {
            this.failureCollector().add((Throwable)e);
            return Collections.emptyList();
        }
    }

    private Collection<PojoIndexingProcessor<? super V>> doBuild(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        PojoIndexingDependencyCollectorValueNode valueDependencyCollector = parentDependencyCollector.value(this.modelPath.getBoundExtractorPath());
        List<Object> immutableNestedNodes = this.boundBridges.isEmpty() && this.typeNodeBuilders.isEmpty() ? Collections.emptyList() : new ArrayList(this.boundBridges.size() + this.typeNodeBuilders.size());
        try {
            for (BoundValueBridge<V, ?> boundBridge : this.boundBridges) {
                immutableNestedNodes.add(PojoIndexingProcessorValueNodeBuilderDelegate.createValueBridgeNode(boundBridge));
            }
            this.typeNodeBuilders.stream().map(builder -> builder.build(valueDependencyCollector)).filter(Optional::isPresent).map(Optional::get).forEach(immutableNestedNodes::add);
            if (!immutableNestedNodes.isEmpty()) {
                valueDependencyCollector.collectDependency();
            }
            return immutableNestedNodes;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(PojoIndexingProcessor::close, immutableNestedNodes);
            throw e;
        }
    }

    private static <V, F> PojoIndexingProcessor<V> createValueBridgeNode(BoundValueBridge<V, F> boundBridge) {
        return new PojoIndexingProcessorValueBridgeNode<V, F>(boundBridge.getBridgeHolder(), boundBridge.getIndexFieldReference());
    }
}

