/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.route.impl.DocumentRouteImpl;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentReferenceProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkRouter;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoIndexedTypeIndexingPlan<I, E, R>
extends AbstractPojoTypeIndexingPlan {
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final IndexIndexingPlan<R> delegate;
    private final Map<I, IndexedEntityIndexingPlan> indexingPlansPerId = new LinkedHashMap<I, IndexedEntityIndexingPlan>();

    public PojoIndexedTypeIndexingPlan(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext<?> sessionContext, IndexIndexingPlan<R> delegate) {
        super(sessionContext);
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    @Override
    void add(Object providedId, String providedRoutingKey, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).add(entitySupplier, providedRoutingKey);
    }

    @Override
    void update(Object providedId, String providedRoutingKey, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).update(entitySupplier, providedRoutingKey);
    }

    @Override
    void update(Object providedId, String providedRoutingKey, Object entity, String ... dirtyPaths) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).update(entitySupplier, providedRoutingKey, dirtyPaths);
    }

    @Override
    void delete(Object providedId, String providedRoutingKey, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getPlan(identifier).delete(entitySupplier, providedRoutingKey);
    }

    @Override
    void purge(Object providedId, String providedRoutingKey) {
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId);
        this.getPlan(identifier).purge(providedRoutingKey);
    }

    void updateBecauseOfContained(Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(null, entitySupplier);
        if (!this.indexingPlansPerId.containsKey(identifier)) {
            this.getPlan(identifier).updateBecauseOfContained(entitySupplier);
        }
    }

    void resolveDirty(PojoReindexingCollector containingEntityCollector) {
        ArrayList<IndexedEntityIndexingPlan> frozenIndexingPlansPerId = new ArrayList<IndexedEntityIndexingPlan>(this.indexingPlansPerId.values());
        for (IndexedEntityIndexingPlan plan : frozenIndexingPlansPerId) {
            plan.resolveDirty(containingEntityCollector);
        }
    }

    void process() {
        this.sendCommandsToDelegate();
        this.getDelegate().process();
    }

    CompletableFuture<IndexIndexingPlanExecutionReport<R>> executeAndReport() {
        this.sendCommandsToDelegate();
        return this.delegate.executeAndReport();
    }

    void discard() {
        this.delegate.discard();
    }

    void discardNotProcessed() {
        this.indexingPlansPerId.clear();
    }

    private IndexedEntityIndexingPlan getPlan(I identifier) {
        IndexedEntityIndexingPlan plan = this.indexingPlansPerId.get(identifier);
        if (plan == null) {
            plan = new IndexedEntityIndexingPlan(identifier);
            this.indexingPlansPerId.put(identifier, plan);
        }
        return plan;
    }

    private IndexIndexingPlan<?> getDelegate() {
        return this.delegate;
    }

    private void sendCommandsToDelegate() {
        try {
            this.indexingPlansPerId.values().forEach(IndexedEntityIndexingPlan::sendCommandsToDelegate);
        }
        finally {
            this.indexingPlansPerId.clear();
        }
    }

    private class IndexedEntityIndexingPlan {
        private final I identifier;
        private String providedRoutingKey;
        private Supplier<E> entitySupplier;
        private boolean delete;
        private boolean add;
        private boolean shouldResolveToReindex;
        private boolean considerAllDirty;
        private boolean updatedBecauseOfContained;
        private Set<String> dirtyPaths;

        private IndexedEntityIndexingPlan(I identifier) {
            this.identifier = identifier;
        }

        void add(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.entitySupplier = entitySupplier;
            this.providedRoutingKey = providedRoutingKey;
            this.shouldResolveToReindex = true;
            this.add = true;
        }

        void update(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.doUpdate(entitySupplier, providedRoutingKey);
            this.shouldResolveToReindex = true;
            this.considerAllDirty = true;
            this.dirtyPaths = null;
        }

        void update(Supplier<E> entitySupplier, String providedRoutingKey, String ... dirtyPaths) {
            this.doUpdate(entitySupplier, providedRoutingKey);
            this.shouldResolveToReindex = true;
            if (!this.considerAllDirty) {
                for (String dirtyPropertyName : dirtyPaths) {
                    this.addDirtyPath(dirtyPropertyName);
                }
            }
        }

        void updateBecauseOfContained(Supplier<E> entitySupplier) {
            this.doUpdate(entitySupplier, null);
            this.updatedBecauseOfContained = true;
        }

        void delete(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.entitySupplier = entitySupplier;
            this.providedRoutingKey = providedRoutingKey;
            if (this.add && !this.delete) {
                this.shouldResolveToReindex = false;
                this.considerAllDirty = false;
                this.updatedBecauseOfContained = false;
                this.dirtyPaths = null;
                this.add = false;
                this.delete = false;
            } else {
                this.add = false;
                this.delete = true;
            }
        }

        void purge(String providedRoutingKey) {
            this.entitySupplier = null;
            this.providedRoutingKey = providedRoutingKey;
            this.shouldResolveToReindex = false;
            this.considerAllDirty = false;
            this.dirtyPaths = null;
            this.add = false;
            this.delete = true;
        }

        void resolveDirty(PojoReindexingCollector containingEntityCollector) {
            if (this.shouldResolveToReindex) {
                this.shouldResolveToReindex = false;
                PojoIndexedTypeIndexingPlan.this.typeContext.resolveEntitiesToReindex(containingEntityCollector, PojoIndexedTypeIndexingPlan.this.sessionContext.runtimeIntrospector(), this.entitySupplier, this.considerAllDirty ? null : this.dirtyPaths);
            }
        }

        void sendCommandsToDelegate() {
            if (this.add) {
                if (this.delete) {
                    if (this.considerAllDirty || this.updatedBecauseOfContained || PojoIndexedTypeIndexingPlan.this.typeContext.requiresSelfReindexing(this.dirtyPaths)) {
                        this.delegateUpdate();
                    }
                } else {
                    this.delegateAdd();
                }
            } else if (this.delete) {
                this.delegateDelete();
            }
        }

        private void doUpdate(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.entitySupplier = entitySupplier;
            this.providedRoutingKey = providedRoutingKey;
            if (!this.add) {
                this.delete = true;
                this.add = true;
            }
        }

        private void addDirtyPath(String dirtyPath) {
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new HashSet<String>();
            }
            this.dirtyPaths.add(dirtyPath);
        }

        private void delegateAdd() {
            PojoWorkRouter router = PojoIndexedTypeIndexingPlan.this.typeContext.createRouter(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier);
            DocumentRouteImpl currentRoute = router.currentRoute(this.providedRoutingKey);
            String documentIdentifier = PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentIdentifier(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier);
            if (currentRoute == null) {
                return;
            }
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), this.identifier);
            PojoIndexedTypeIndexingPlan.this.delegate.add((DocumentReferenceProvider)referenceProvider, PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentContributor(this.entitySupplier, PojoIndexedTypeIndexingPlan.this.sessionContext));
        }

        private void delegateUpdate() {
            PojoWorkRouter router = PojoIndexedTypeIndexingPlan.this.typeContext.createRouter(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier);
            DocumentRouteImpl currentRoute = router.currentRoute(this.providedRoutingKey);
            List<DocumentRouteImpl> previousRoutes = router.previousRoutes(currentRoute);
            String documentIdentifier = PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentIdentifier(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier);
            this.delegateDeletePrevious(documentIdentifier, previousRoutes);
            if (currentRoute == null) {
                return;
            }
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), this.identifier);
            PojoIndexedTypeIndexingPlan.this.delegate.update((DocumentReferenceProvider)referenceProvider, PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentContributor(this.entitySupplier, PojoIndexedTypeIndexingPlan.this.sessionContext));
        }

        private void delegateDelete() {
            String documentIdentifier = PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentIdentifier(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier);
            if (this.entitySupplier == null) {
                PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, this.providedRoutingKey, this.identifier);
                PojoIndexedTypeIndexingPlan.this.delegate.delete((DocumentReferenceProvider)referenceProvider);
                return;
            }
            PojoWorkRouter router = PojoIndexedTypeIndexingPlan.this.typeContext.createRouter(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier);
            DocumentRouteImpl currentRoute = router.currentRoute(this.providedRoutingKey);
            List<DocumentRouteImpl> previousRoutes = router.previousRoutes(currentRoute);
            this.delegateDeletePrevious(documentIdentifier, previousRoutes);
            if (currentRoute == null) {
                return;
            }
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), this.identifier);
            PojoIndexedTypeIndexingPlan.this.delegate.delete((DocumentReferenceProvider)referenceProvider);
        }

        private void delegateDeletePrevious(String documentIdentifier, List<DocumentRouteImpl> previousRoutes) {
            for (DocumentRouteImpl route : previousRoutes) {
                PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, route.routingKey(), this.identifier);
                PojoIndexedTypeIndexingPlan.this.delegate.delete((DocumentReferenceProvider)referenceProvider);
            }
        }
    }
}

