/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexer;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexerImpl
implements PojoIndexer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkIndexedTypeContextProvider indexedTypeContextProvider;
    private final PojoWorkSessionContext<?> sessionContext;
    private final Map<PojoRawTypeIdentifier<?>, PojoTypeIndexer<?, ?>> delegates = new ConcurrentHashMap();

    public PojoIndexerImpl(PojoWorkIndexedTypeContextProvider indexedTypeContextProvider, PojoWorkSessionContext<?> sessionContext) {
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.sessionContext = sessionContext;
    }

    @Override
    public CompletableFuture<?> add(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, String providedRoutingKey, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.getDelegate(typeIdentifier).add(providedId, providedRoutingKey, entity, commitStrategy, refreshStrategy);
    }

    @Override
    public CompletableFuture<?> addOrUpdate(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, String providedRoutingKey, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.getDelegate(typeIdentifier).addOrUpdate(providedId, providedRoutingKey, entity, commitStrategy, refreshStrategy);
    }

    @Override
    public CompletableFuture<?> delete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, String providedRoutingKey, Object entity, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.getDelegate(typeIdentifier).delete(providedId, providedRoutingKey, entity, commitStrategy, refreshStrategy);
    }

    @Override
    public CompletableFuture<?> purge(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, String providedRoutingKey, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.getDelegate(typeIdentifier).purge(providedId, providedRoutingKey, commitStrategy, refreshStrategy);
    }

    private PojoTypeIndexer<?, ?> getDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        PojoTypeIndexer delegate = this.delegates.get(typeIdentifier);
        if (delegate == null) {
            delegate = this.delegates.computeIfAbsent(typeIdentifier, this::createTypeIndexer);
        }
        return delegate;
    }

    private PojoTypeIndexer<?, ?> createTypeIndexer(PojoRawTypeIdentifier<?> typeIdentifier) {
        Optional<PojoWorkIndexedTypeContext<?, ?>> typeContext = this.indexedTypeContextProvider.getByExactType(typeIdentifier);
        if (!typeContext.isPresent()) {
            throw log.notDirectlyIndexedType(typeIdentifier);
        }
        return typeContext.get().createIndexer(this.sessionContext);
    }
}

