/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;


@SuppressWarnings("deprecation")
class RoutingKeyBridgeMappingContributor implements PojoTypeMetadataContributor {

	private final org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder routingKeyBinder;

	RoutingKeyBridgeMappingContributor(org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder routingKeyBinder) {
		this.routingKeyBinder = routingKeyBinder;
	}

	@Override
	public void contributeAdditionalMetadata(PojoAdditionalMetadataCollectorTypeNode collector) {
		// Nothing to do
	}

	@Override
	public void contributeMapping(PojoMappingCollectorTypeNode collector) {
		collector.routingKeyBinder( routingKeyBinder );
	}

}
