/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.PojoIdentifierBridgeToDocumentIdentifierValueConverter;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DefaultIdentifierBindingContext<I>
extends AbstractBindingContext
implements IdentifierBindingContext<I> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoBootstrapIntrospector introspector;
    private final IndexedEntityBindingContext indexedEntityBindingContext;
    private final PojoGenericTypeModel<I> identifierTypeModel;
    private final PojoModelValue<I> bridgedElement;
    private PartialBinding<I> partialBinding;

    public DefaultIdentifierBindingContext(BeanResolver beanResolver, PojoBootstrapIntrospector introspector, IndexedEntityBindingContext indexedEntityBindingContext, PojoGenericTypeModel<I> valueTypeModel) {
        super(beanResolver);
        this.introspector = introspector;
        this.indexedEntityBindingContext = indexedEntityBindingContext;
        this.identifierTypeModel = valueTypeModel;
        this.bridgedElement = new PojoModelValueElement<I>(introspector, valueTypeModel);
    }

    @Override
    public <I2> void bridge(Class<I2> expectedValueType, IdentifierBridge<I2> bridge) {
        this.bridge(expectedValueType, BeanHolder.of(bridge));
    }

    @Override
    public <I2> void bridge(Class<I2> expectedValueType, BeanHolder<? extends IdentifierBridge<I2>> bridgeHolder) {
        try {
            PojoRawTypeModel<I2> expectedValueTypeModel = this.introspector.typeModel(expectedValueType);
            if (!this.identifierTypeModel.rawType().equals(expectedValueTypeModel)) {
                throw log.invalidInputTypeForBridge(bridgeHolder.get(), this.identifierTypeModel);
            }
            BeanHolder<? extends IdentifierBridge<I2>> castedBridgeHolder = bridgeHolder;
            Class<I2> castedExpectedType = expectedValueType;
            this.partialBinding = new PartialBinding(castedBridgeHolder, castedExpectedType);
        }
        catch (RuntimeException e) {
            DefaultIdentifierBindingContext.abortBridge(new SuppressingCloser((Throwable)e), bridgeHolder);
            throw e;
        }
    }

    @Override
    public PojoModelValue<I> bridgedElement() {
        return this.bridgedElement;
    }

    public BoundIdentifierBridge<I> applyBinder(IdentifierBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingBridgeForBinder(binder);
            }
            BoundIdentifierBridge<I> boundIdentifierBridge = this.partialBinding.complete(this.indexedEntityBindingContext);
            return boundIdentifierBridge;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private static void abortBridge(AbstractCloser<?, ?> closer, BeanHolder<? extends IdentifierBridge<?>> bridgeHolder) {
        closer.push(holder -> ((IdentifierBridge)holder.get()).close(), bridgeHolder);
        closer.push(BeanHolder::close, bridgeHolder);
    }

    private static class PartialBinding<I> {
        private final BeanHolder<? extends IdentifierBridge<I>> bridgeHolder;
        private final Class<I> expectedValueType;

        private PartialBinding(BeanHolder<? extends IdentifierBridge<I>> bridgeHolder, Class<I> expectedValueType) {
            this.bridgeHolder = bridgeHolder;
            this.expectedValueType = expectedValueType;
        }

        void abort(AbstractCloser<?, ?> closer) {
            DefaultIdentifierBindingContext.abortBridge(closer, this.bridgeHolder);
        }

        BoundIdentifierBridge<I> complete(IndexedEntityBindingContext indexedEntityBindingContext) {
            indexedEntityBindingContext.idDslConverter(new PojoIdentifierBridgeToDocumentIdentifierValueConverter<I>((IdentifierBridge)this.bridgeHolder.get(), this.expectedValueType));
            return new BoundIdentifierBridge(this.bridgeHolder);
        }
    }
}

