/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerBuilder;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingBridge;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoRootIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexedTypeManagerBuilder<E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String entityName;
    private final PojoRawTypeModel<E> typeModel;
    private final MappedIndexManagerBuilder indexManagerBuilder;
    private final PojoIndexedTypeExtendedMappingCollector extendedMappingCollector;
    private final PojoRootIdentityMappingCollector<E> identityMappingCollector;
    private final PojoIndexingProcessorOriginalTypeNodeBuilder<E> processorBuilder;
    private PojoIndexingProcessor<E> preBuiltIndexingProcessor;
    private boolean closed = false;

    PojoIndexedTypeManagerBuilder(String entityName, PojoRawTypeModel<E> typeModel, PojoMappingHelper mappingHelper, MappedIndexManagerBuilder indexManagerBuilder, PojoIndexedTypeExtendedMappingCollector extendedMappingCollector, BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge, BoundRoutingBridge<E> routingBridge, BeanResolver beanResolver) {
        this.entityName = entityName;
        this.typeModel = typeModel;
        this.indexManagerBuilder = indexManagerBuilder;
        this.extendedMappingCollector = extendedMappingCollector;
        this.identityMappingCollector = new PojoRootIdentityMappingCollector<E>(typeModel, mappingHelper, indexManagerBuilder.rootBindingContext(), providedIdentifierBridge, routingBridge, beanResolver);
        this.processorBuilder = new PojoIndexingProcessorOriginalTypeNodeBuilder<E>(BoundPojoModelPath.root(typeModel), mappingHelper, (IndexBindingContext)indexManagerBuilder.rootBindingContext(), this.identityMappingCollector, Collections.emptyList());
    }

    void closeOnFailure() {
        if (this.closed) {
            return;
        }
        try (Closer closer = new Closer();){
            closer.push(AbstractPojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.processorBuilder);
            closer.push(PojoRootIdentityMappingCollector::closeOnFailure, this.identityMappingCollector);
            closer.push(PojoIndexingProcessor::close, this.preBuiltIndexingProcessor);
            this.closed = true;
        }
    }

    PojoMappingCollectorTypeNode asCollector() {
        return this.processorBuilder;
    }

    void preBuild(PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        if (this.preBuiltIndexingProcessor != null) {
            throw new AssertionFailure("Internal error - preBuild should be called only once");
        }
        PojoIndexingDependencyCollectorTypeNode<E> dependencyCollector = reindexingResolverBuildingHelper.createDependencyCollector(this.typeModel);
        if (this.identityMappingCollector.routingBridge != null) {
            this.identityMappingCollector.routingBridge.contributeDependencies(dependencyCollector);
        }
        this.preBuiltIndexingProcessor = this.processorBuilder.build(dependencyCollector).orElseGet(PojoIndexingProcessor::noOp);
    }

    void buildAndAddTo(PojoIndexedTypeManagerContainer.Builder typeManagersBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper, PojoTypeAdditionalMetadata typeAdditionalMetadata) {
        if (this.preBuiltIndexingProcessor == null) {
            throw new AssertionFailure("Internal error - preBuild should be called before buildAndAddTo");
        }
        this.identityMappingCollector.applyDefaults();
        if (this.identityMappingCollector.documentIdSourceProperty.isPresent()) {
            this.extendedMappingCollector.documentIdSourceProperty(this.identityMappingCollector.documentIdSourceProperty.get());
        }
        this.extendedMappingCollector.identifierMapping(this.identityMappingCollector.identifierMapping);
        PojoPathFilterFactory<Set<String>> pathFilterFactory = typeAdditionalMetadata.getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(this.typeModel)).getPathFilterFactory();
        PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver = reindexingResolverBuildingHelper.build(this.typeModel, pathFilterFactory);
        MappedIndexManager indexManager = this.indexManagerBuilder.build();
        this.extendedMappingCollector.indexManager(indexManager);
        PojoIndexedTypeManager typeManager = new PojoIndexedTypeManager(this.entityName, this.typeModel.typeIdentifier(), this.typeModel.caster(), this.identityMappingCollector.identifierMapping, this.identityMappingCollector.routingBridge == null ? null : this.identityMappingCollector.routingBridge.getBridgeHolder(), this.preBuiltIndexingProcessor, indexManager, reindexingResolver);
        log.createdPojoIndexedTypeManager(typeManager);
        typeManagersBuilder.add(this.typeModel, typeManager);
        this.closed = true;
    }
}

