/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.TypeMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl.AnnotationProcessorProvider;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl.PropertyMappingAnnotationProcessorContextImpl;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl.TypeMappingAnnotationProcessorContextImpl;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeMappingStepImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.reflect.spi.AnnotationHelper;

class AnnotationPojoTypeMetadataContributorFactory {
    private final FailureCollector rootFailureCollector;
    private final PojoMappingConfigurationContext configurationContext;
    private final AnnotationHelper annotationHelper;
    private final AnnotationProcessorProvider annotationProcessorProvider;

    AnnotationPojoTypeMetadataContributorFactory(BeanResolver beanResolver, FailureCollector rootFailureCollector, PojoMappingConfigurationContext configurationContext, AnnotationHelper annotationHelper) {
        this.rootFailureCollector = rootFailureCollector;
        this.configurationContext = configurationContext;
        this.annotationHelper = annotationHelper;
        this.annotationProcessorProvider = new AnnotationProcessorProvider(beanResolver, rootFailureCollector);
    }

    public Optional<PojoTypeMetadataContributor> createIfAnnotated(PojoRawTypeModel<?> typeModel) {
        TypeMappingStepImpl typeMappingStep = new TypeMappingStepImpl(typeModel);
        boolean processedTypeLevelAnnotation = this.processTypeLevelAnnotations(typeMappingStep, typeModel);
        boolean processedPropertyLevelAnnotation = typeModel.declaredProperties().map(propertyModel -> this.processPropertyLevelAnnotations(typeMappingStep, typeModel, (PojoPropertyModel<?>)propertyModel)).reduce((processedAnnotationHere, processedAnnotationThere) -> processedAnnotationHere != false || processedAnnotationThere != false).orElse(false);
        if (!processedTypeLevelAnnotation && !processedPropertyLevelAnnotation) {
            return Optional.empty();
        }
        return Optional.of(typeMappingStep);
    }

    private boolean processTypeLevelAnnotations(TypeMappingStepImpl typeMappingContext, PojoRawTypeModel<?> typeModel) {
        boolean processedAtLeastOneAnnotation = false;
        List annotationList = typeModel.annotations().flatMap(arg_0 -> ((AnnotationHelper)this.annotationHelper).expandRepeatableContainingAnnotation(arg_0)).collect(Collectors.toList());
        for (Annotation annotation : annotationList) {
            if (!this.tryApplyProcessor(typeMappingContext, typeModel, annotation)) continue;
            processedAtLeastOneAnnotation = true;
        }
        return processedAtLeastOneAnnotation;
    }

    private boolean processPropertyLevelAnnotations(TypeMappingStepImpl typeMappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel) {
        String propertyName = propertyModel.name();
        PropertyMappingStep mappingContext = typeMappingContext.property(propertyName);
        boolean processedAtLeastOneAnnotation = false;
        List annotationList = propertyModel.annotations().flatMap(arg_0 -> ((AnnotationHelper)this.annotationHelper).expandRepeatableContainingAnnotation(arg_0)).collect(Collectors.toList());
        for (Annotation annotation : annotationList) {
            if (!this.tryApplyProcessor(mappingContext, typeModel, propertyModel, annotation)) continue;
            processedAtLeastOneAnnotation = true;
        }
        return processedAtLeastOneAnnotation;
    }

    private <A extends Annotation> boolean tryApplyProcessor(TypeMappingStep mapping, PojoRawTypeModel<?> typeModel, A annotation) {
        Optional<BeanHolder<TypeMappingAnnotationProcessor<A>>> processorOptional = this.annotationProcessorProvider.createTypeAnnotationProcessor(annotation);
        if (!processorOptional.isPresent()) {
            return false;
        }
        TypeMappingAnnotationProcessorContextImpl context = new TypeMappingAnnotationProcessorContextImpl(typeModel, annotation, this.annotationHelper);
        try (BeanHolder<TypeMappingAnnotationProcessor<A>> processorHolder = processorOptional.get();){
            ((TypeMappingAnnotationProcessor)processorHolder.get()).process(mapping, annotation, context);
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(context.eventContext()).add((Throwable)e);
        }
        return true;
    }

    private <A extends Annotation> boolean tryApplyProcessor(PropertyMappingStep mapping, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, A annotation) {
        Optional<BeanHolder<PropertyMappingAnnotationProcessor<A>>> processorOptional = this.annotationProcessorProvider.createPropertyAnnotationProcessor(annotation);
        if (!processorOptional.isPresent()) {
            return false;
        }
        PropertyMappingAnnotationProcessorContextImpl context = new PropertyMappingAnnotationProcessorContextImpl(typeModel, propertyModel, annotation, this.annotationHelper, this.configurationContext);
        try (BeanHolder<PropertyMappingAnnotationProcessor<A>> processorHolder = processorOptional.get();){
            ((PropertyMappingAnnotationProcessor)processorHolder.get()).process(mapping, annotation, context);
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(context.eventContext()).add((Throwable)e);
        }
        return true;
    }
}

