/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.spi;

import java.util.Set;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;

public final class StringSetPojoPathFilter
implements PojoPathFilter<Set<String>> {
    private final Set<String> acceptedPaths;

    public StringSetPojoPathFilter(Set<String> acceptedPaths) {
        this.acceptedPaths = acceptedPaths;
    }

    @Override
    public boolean test(Set<String> paths) {
        Set<String> iterationSet = this.acceptedPaths;
        Set<String> containsSet = paths;
        if (paths.size() < this.acceptedPaths.size()) {
            iterationSet = paths;
            containsSet = this.acceptedPaths;
        }
        for (String path : iterationSet) {
            if (!containsSet.contains(path)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.acceptedPaths + "]";
    }
}

