/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorOriginalTypeNode<T>
extends PojoIndexingProcessor<T> {
    private final Iterable<IndexObjectFieldReference> parentIndexObjectReferences;
    private final PojoIndexingProcessor<? super T> nested;

    public PojoIndexingProcessorOriginalTypeNode(Iterable<IndexObjectFieldReference> parentIndexObjectReferences, PojoIndexingProcessor<? super T> nested) {
        this.parentIndexObjectReferences = parentIndexObjectReferences;
        this.nested = nested;
    }

    @Override
    public void close() {
        this.nested.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process type");
        builder.attribute("objectFieldsToCreate", this.parentIndexObjectReferences);
        builder.attribute("nested", this.nested);
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorSessionContext sessionContext) {
        if (source == null) {
            return;
        }
        source = sessionContext.runtimeIntrospector().unproxy(source);
        DocumentElement parentObject = target;
        for (IndexObjectFieldReference objectFieldReference : this.parentIndexObjectReferences) {
            parentObject = parentObject.addObject(objectFieldReference);
        }
        this.nested.process(parentObject, source, sessionContext);
    }
}

