/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.util.function.Supplier;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoBackendMappingContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class PropertyIdentifierMapping<I, E>
implements IdentifierMappingImplementor<I, E> {
    private final PojoCaster<? super I> caster;
    private final ValueReadHandle<I> property;
    private final BeanHolder<? extends IdentifierBridge<I>> bridgeHolder;

    public PropertyIdentifierMapping(PojoCaster<? super I> caster, ValueReadHandle<I> property, BeanHolder<? extends IdentifierBridge<I>> bridgeHolder) {
        this.caster = caster;
        this.property = property;
        this.bridgeHolder = bridgeHolder;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(holder -> ((IdentifierBridge)holder.get()).close(), this.bridgeHolder);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    @Override
    public I getIdentifier(Object providedId) {
        return this.caster.cast(providedId);
    }

    @Override
    public I getIdentifier(Object providedId, Supplier<? extends E> entitySupplier) {
        if (providedId != null) {
            return this.getIdentifier(providedId);
        }
        return (I)this.property.get(entitySupplier.get());
    }

    @Override
    public String toDocumentIdentifier(I identifier, AbstractPojoBackendMappingContext context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).toDocumentIdentifier(identifier, context.getIdentifierBridgeToDocumentIdentifierContext());
    }

    public I fromDocumentIdentifier(String documentId, AbstractPojoBackendSessionContext context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).fromDocumentIdentifier(documentId, context.getIdentifierBridgeFromDocumentIdentifierContext());
    }
}

