/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.MarkerBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.PropertyBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.RoutingKeyBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.TypeBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtraction;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AssociationInverseSide;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.IndexedEmbedded;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.IndexingDependency;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.KeywordField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ScaledNumberField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorHelper;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.PropertyAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.PropertyFieldAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.PropertyNotFullTextFieldAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.TypeAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.IndexingDependencyOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingFullTextFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingKeywordFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingNonFullTextFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingScaledNumberFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingStep;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class AnnotationProcessorProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<TypeAnnotationProcessor<?>> typeAnnotationProcessors;
    private final List<PropertyAnnotationProcessor<?>> propertyAnnotationProcessors;

    AnnotationProcessorProvider(FailureCollector rootFailureCollector) {
        AnnotationProcessorHelper helper = new AnnotationProcessorHelper(rootFailureCollector);
        this.typeAnnotationProcessors = CollectionHelper.toImmutableList((List)CollectionHelper.asList((Object)new IndexedProcessor(helper), (Object[])new TypeAnnotationProcessor[]{new RoutingKeyBridgeProcessor(helper), new TypeBridgeProcessor(helper)}));
        this.propertyAnnotationProcessors = CollectionHelper.toImmutableList((List)CollectionHelper.asList((Object)new MarkerProcessor(helper), (Object[])new PropertyAnnotationProcessor[]{new AssociationInverseSideProcessor(helper), new IndexingDependencyProcessor(helper), new DocumentIdProcessor(helper), new PropertyBridgeProcessor(helper), new GenericFieldProcessor(helper), new FullTextFieldProcessor(helper), new KeywordFieldProcessor(helper), new ScaledNumberFieldProcessor(helper), new IndexedEmbeddedProcessor(helper)}));
    }

    List<TypeAnnotationProcessor<?>> getTypeAnnotationProcessors() {
        return this.typeAnnotationProcessors;
    }

    List<PropertyAnnotationProcessor<?>> getPropertyAnnotationProcessors() {
        return this.propertyAnnotationProcessors;
    }

    private static class IndexedEmbeddedProcessor
    extends PropertyAnnotationProcessor<IndexedEmbedded> {
        IndexedEmbeddedProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends IndexedEmbedded> extractAnnotations(PojoPropertyModel<?> propertyModel) {
            return propertyModel.getAnnotationsByType(IndexedEmbedded.class);
        }

        @Override
        void doProcess(PropertyMappingStep mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, IndexedEmbedded annotation) {
            Set<String> cleanedUpIncludePaths;
            String[] includePathsArray;
            Integer cleanedUpMaxDepth;
            String cleanedUpPrefix = annotation.prefix();
            if (cleanedUpPrefix.isEmpty()) {
                cleanedUpPrefix = null;
            }
            if ((cleanedUpMaxDepth = Integer.valueOf(annotation.maxDepth())).equals(-1)) {
                cleanedUpMaxDepth = null;
            }
            if ((includePathsArray = annotation.includePaths()).length > 0) {
                cleanedUpIncludePaths = new HashSet();
                Collections.addAll(cleanedUpIncludePaths, includePathsArray);
            } else {
                cleanedUpIncludePaths = Collections.emptySet();
            }
            ContainerExtractorPath extractorPath = this.helper.getExtractorPath(annotation.extraction());
            mappingContext.indexedEmbedded().extractors(extractorPath).prefix(cleanedUpPrefix).storage(annotation.storage()).maxDepth(cleanedUpMaxDepth).includePaths(cleanedUpIncludePaths);
        }
    }

    private static class ScaledNumberFieldProcessor
    extends PropertyNotFullTextFieldAnnotationProcessor<ScaledNumberField> {
        ScaledNumberFieldProcessor(AnnotationProcessorHelper helper) {
            super(helper, ScaledNumberField.class);
        }

        @Override
        PropertyMappingNonFullTextFieldOptionsStep<?> initSortableFieldMappingContext(PropertyMappingStep mappingContext, PojoPropertyModel<?> propertyModel, ScaledNumberField annotation, String fieldName) {
            PropertyMappingScaledNumberFieldOptionsStep fieldContext = mappingContext.scaledNumberField(fieldName);
            int decimalScale = annotation.decimalScale();
            if (decimalScale != Integer.MAX_VALUE) {
                fieldContext.decimalScale(decimalScale);
            }
            return fieldContext;
        }

        @Override
        String getName(ScaledNumberField annotation) {
            return annotation.name();
        }

        @Override
        Projectable getProjectable(ScaledNumberField annotation) {
            return annotation.projectable();
        }

        @Override
        Searchable getSearchable(ScaledNumberField annotation) {
            return annotation.searchable();
        }

        @Override
        Sortable getSortable(ScaledNumberField annotation) {
            return annotation.sortable();
        }

        @Override
        Aggregable getAggregable(ScaledNumberField annotation) {
            return annotation.aggregable();
        }

        @Override
        String getIndexNullAs(ScaledNumberField annotation) {
            return annotation.indexNullAs();
        }

        @Override
        ValueBridgeRef getValueBridge(ScaledNumberField annotation) {
            return annotation.valueBridge();
        }

        @Override
        ValueBinderRef getValueBinder(ScaledNumberField annotation) {
            return annotation.valueBinder();
        }

        @Override
        ContainerExtraction getExtraction(ScaledNumberField annotation) {
            return annotation.extraction();
        }
    }

    private static class KeywordFieldProcessor
    extends PropertyNotFullTextFieldAnnotationProcessor<KeywordField> {
        KeywordFieldProcessor(AnnotationProcessorHelper helper) {
            super(helper, KeywordField.class);
        }

        @Override
        PropertyMappingNonFullTextFieldOptionsStep<?> initSortableFieldMappingContext(PropertyMappingStep mappingContext, PojoPropertyModel<?> propertyModel, KeywordField annotation, String fieldName) {
            Norms norms;
            PropertyMappingKeywordFieldOptionsStep fieldContext = mappingContext.keywordField(fieldName);
            String normalizer = annotation.normalizer();
            if (!normalizer.isEmpty()) {
                fieldContext.normalizer(annotation.normalizer());
            }
            if (!Norms.DEFAULT.equals((Object)(norms = annotation.norms()))) {
                fieldContext.norms(norms);
            }
            return fieldContext;
        }

        @Override
        String getName(KeywordField annotation) {
            return annotation.name();
        }

        @Override
        Projectable getProjectable(KeywordField annotation) {
            return annotation.projectable();
        }

        @Override
        Searchable getSearchable(KeywordField annotation) {
            return annotation.searchable();
        }

        @Override
        Sortable getSortable(KeywordField annotation) {
            return annotation.sortable();
        }

        @Override
        Aggregable getAggregable(KeywordField annotation) {
            return annotation.aggregable();
        }

        @Override
        String getIndexNullAs(KeywordField annotation) {
            return annotation.indexNullAs();
        }

        @Override
        ValueBridgeRef getValueBridge(KeywordField annotation) {
            return annotation.valueBridge();
        }

        @Override
        ValueBinderRef getValueBinder(KeywordField annotation) {
            return annotation.valueBinder();
        }

        @Override
        ContainerExtraction getExtraction(KeywordField annotation) {
            return annotation.extraction();
        }
    }

    private static class FullTextFieldProcessor
    extends PropertyFieldAnnotationProcessor<FullTextField> {
        FullTextFieldProcessor(AnnotationProcessorHelper helper) {
            super(helper, FullTextField.class);
        }

        @Override
        PropertyMappingFieldOptionsStep<?> initFieldMappingContext(PropertyMappingStep mappingContext, PojoPropertyModel<?> propertyModel, FullTextField annotation, String fieldName) {
            TermVector termVector;
            Norms norms;
            PropertyMappingFullTextFieldOptionsStep fieldContext = mappingContext.fullTextField(fieldName).analyzer(annotation.analyzer());
            if (!annotation.searchAnalyzer().isEmpty()) {
                fieldContext.searchAnalyzer(annotation.searchAnalyzer());
            }
            if (!Norms.DEFAULT.equals((Object)(norms = annotation.norms()))) {
                fieldContext.norms(norms);
            }
            if (!TermVector.DEFAULT.equals((Object)(termVector = annotation.termVector()))) {
                fieldContext.termVector(termVector);
            }
            return fieldContext;
        }

        @Override
        String getName(FullTextField annotation) {
            return annotation.name();
        }

        @Override
        Projectable getProjectable(FullTextField annotation) {
            return annotation.projectable();
        }

        @Override
        Searchable getSearchable(FullTextField annotation) {
            return annotation.searchable();
        }

        @Override
        ValueBridgeRef getValueBridge(FullTextField annotation) {
            return annotation.valueBridge();
        }

        @Override
        ValueBinderRef getValueBinder(FullTextField annotation) {
            return annotation.valueBinder();
        }

        @Override
        ContainerExtraction getExtraction(FullTextField annotation) {
            return annotation.extraction();
        }
    }

    private static class GenericFieldProcessor
    extends PropertyNotFullTextFieldAnnotationProcessor<GenericField> {
        GenericFieldProcessor(AnnotationProcessorHelper helper) {
            super(helper, GenericField.class);
        }

        @Override
        PropertyMappingNonFullTextFieldOptionsStep<?> initSortableFieldMappingContext(PropertyMappingStep mappingContext, PojoPropertyModel<?> propertyModel, GenericField annotation, String fieldName) {
            return mappingContext.genericField(fieldName);
        }

        @Override
        String getName(GenericField annotation) {
            return annotation.name();
        }

        @Override
        Projectable getProjectable(GenericField annotation) {
            return annotation.projectable();
        }

        @Override
        Searchable getSearchable(GenericField annotation) {
            return annotation.searchable();
        }

        @Override
        Sortable getSortable(GenericField annotation) {
            return annotation.sortable();
        }

        @Override
        Aggregable getAggregable(GenericField annotation) {
            return annotation.aggregable();
        }

        @Override
        String getIndexNullAs(GenericField annotation) {
            return annotation.indexNullAs();
        }

        @Override
        ValueBridgeRef getValueBridge(GenericField annotation) {
            return annotation.valueBridge();
        }

        @Override
        ValueBinderRef getValueBinder(GenericField annotation) {
            return annotation.valueBinder();
        }

        @Override
        ContainerExtraction getExtraction(GenericField annotation) {
            return annotation.extraction();
        }
    }

    private static class PropertyBridgeProcessor
    extends PropertyAnnotationProcessor<Annotation> {
        PropertyBridgeProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends Annotation> extractAnnotations(PojoPropertyModel<?> propertyModel) {
            return propertyModel.getAnnotationsByMetaAnnotationType(PropertyBinding.class);
        }

        @Override
        void doProcess(PropertyMappingStep mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, Annotation annotation) {
            PropertyBinder binder = this.helper.createPropertyBinder(annotation);
            mappingContext.binder(binder);
        }
    }

    private static class TypeBridgeProcessor
    extends TypeAnnotationProcessor<Annotation> {
        TypeBridgeProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends Annotation> extractAnnotations(PojoRawTypeModel<?> typeModel) {
            return typeModel.getAnnotationsByMetaAnnotationType(TypeBinding.class);
        }

        @Override
        void doProcess(TypeMappingStep mappingContext, PojoRawTypeModel<?> typeModel, Annotation annotation) {
            TypeBinder binder = this.helper.createTypeBinder(annotation);
            mappingContext.binder(binder);
        }
    }

    private static class RoutingKeyBridgeProcessor
    extends TypeAnnotationProcessor<Annotation> {
        RoutingKeyBridgeProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends Annotation> extractAnnotations(PojoRawTypeModel<?> typeModel) {
            return typeModel.getAnnotationsByMetaAnnotationType(RoutingKeyBinding.class);
        }

        @Override
        void doProcess(TypeMappingStep mappingContext, PojoRawTypeModel<?> typeModel, Annotation annotation) {
            RoutingKeyBinder binder = this.helper.createRoutingKeyBinder(annotation);
            mappingContext.routingKeyBinder(binder);
        }
    }

    private static class IndexedProcessor
    extends TypeAnnotationProcessor<Indexed> {
        IndexedProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends Indexed> extractAnnotations(PojoRawTypeModel<?> typeModel) {
            return typeModel.getAnnotationsByType(Indexed.class);
        }

        @Override
        void doProcess(TypeMappingStep mappingContext, PojoRawTypeModel<?> typeModel, Indexed annotation) {
            String backendName;
            String indexName = annotation.index();
            if (indexName.isEmpty()) {
                indexName = null;
            }
            if ((backendName = annotation.backend()).isEmpty()) {
                backendName = null;
            }
            mappingContext.indexed(backendName, indexName);
        }
    }

    private static class DocumentIdProcessor
    extends PropertyAnnotationProcessor<DocumentId> {
        DocumentIdProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends DocumentId> extractAnnotations(PojoPropertyModel<?> propertyModel) {
            return propertyModel.getAnnotationsByType(DocumentId.class);
        }

        @Override
        void doProcess(PropertyMappingStep mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, DocumentId annotation) {
            IdentifierBinder binder = this.helper.createIdentifierBinder(annotation, propertyModel);
            mappingContext.documentId().identifierBinder(binder);
        }
    }

    private static class IndexingDependencyProcessor
    extends PropertyAnnotationProcessor<IndexingDependency> {
        IndexingDependencyProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends IndexingDependency> extractAnnotations(PojoPropertyModel<?> propertyModel) {
            return propertyModel.getAnnotationsByType(IndexingDependency.class);
        }

        @Override
        void doProcess(PropertyMappingStep mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, IndexingDependency annotation) {
            ContainerExtractorPath extractorPath = this.helper.getExtractorPath(annotation.extraction());
            ReindexOnUpdate reindexOnUpdate = annotation.reindexOnUpdate();
            IndexingDependencyOptionsStep indexingDependencyContext = mappingContext.indexingDependency().extractors(extractorPath);
            indexingDependencyContext.reindexOnUpdate(reindexOnUpdate);
            ObjectPath[] derivedFromAnnotations = annotation.derivedFrom();
            if (derivedFromAnnotations.length > 0) {
                for (ObjectPath objectPath : annotation.derivedFrom()) {
                    Optional<PojoModelPathValueNode> pojoModelPathOptional = this.helper.getPojoModelPathValueNode(objectPath);
                    if (!pojoModelPathOptional.isPresent()) {
                        throw log.missingPathInIndexingDependencyDerivedFrom(typeModel, propertyModel.getName());
                    }
                    indexingDependencyContext.derivedFrom(pojoModelPathOptional.get());
                }
            }
        }
    }

    private static class AssociationInverseSideProcessor
    extends PropertyAnnotationProcessor<AssociationInverseSide> {
        AssociationInverseSideProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends AssociationInverseSide> extractAnnotations(PojoPropertyModel<?> propertyModel) {
            return propertyModel.getAnnotationsByType(AssociationInverseSide.class);
        }

        @Override
        void doProcess(PropertyMappingStep mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, AssociationInverseSide annotation) {
            ContainerExtractorPath extractorPath = this.helper.getExtractorPath(annotation.extraction());
            Optional<PojoModelPathValueNode> inversePathOptional = this.helper.getPojoModelPathValueNode(annotation.inversePath());
            if (!inversePathOptional.isPresent()) {
                throw log.missingInversePathInAssociationInverseSideMapping(typeModel, propertyModel.getName());
            }
            mappingContext.associationInverseSide(inversePathOptional.get()).extractors(extractorPath);
        }
    }

    private static class MarkerProcessor
    extends PropertyAnnotationProcessor<Annotation> {
        MarkerProcessor(AnnotationProcessorHelper helper) {
            super(helper);
        }

        @Override
        Stream<? extends Annotation> extractAnnotations(PojoPropertyModel<?> propertyModel) {
            return propertyModel.getAnnotationsByMetaAnnotationType(MarkerBinding.class);
        }

        @Override
        void doProcess(PropertyMappingStep mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, Annotation annotation) {
            MarkerBinder binder = this.helper.createMarkerBinder(annotation);
            mappingContext.marker(binder);
        }
    }
}

