/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIdentityMappingCollectorImpl;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoEntityTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexedTypeManagerBuilder<E, D extends DocumentElement> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeModel<E> typeModel;
    private final MappedIndexManagerBuilder<D> indexManagerBuilder;
    private final PojoIndexedTypeExtendedMappingCollector extendedMappingCollector;
    private final PojoIdentityMappingCollectorImpl<E> identityMappingCollector;
    private final PojoIndexingProcessorTypeNodeBuilder<E> processorBuilder;
    private PojoIndexingProcessor<E> preBuiltIndexingProcessor;
    private boolean closed = false;

    PojoIndexedTypeManagerBuilder(PojoRawTypeModel<E> typeModel, PojoEntityTypeAdditionalMetadata entityTypeMetadata, PojoMappingHelper mappingHelper, MappedIndexManagerBuilder<D> indexManagerBuilder, PojoIndexedTypeExtendedMappingCollector extendedMappingCollector, boolean implicitProvidedId) {
        this.typeModel = typeModel;
        this.indexManagerBuilder = indexManagerBuilder;
        this.extendedMappingCollector = extendedMappingCollector;
        this.identityMappingCollector = new PojoIdentityMappingCollectorImpl<E>(typeModel, entityTypeMetadata, mappingHelper, indexManagerBuilder.getRootBindingContext(), implicitProvidedId);
        this.processorBuilder = new PojoIndexingProcessorTypeNodeBuilder<E>(BoundPojoModelPath.root(typeModel), mappingHelper, (IndexBindingContext)indexManagerBuilder.getRootBindingContext(), Optional.of(this.identityMappingCollector), Collections.emptyList());
    }

    void closeOnFailure() {
        if (this.closed) {
            return;
        }
        try (Closer closer = new Closer();){
            closer.push(PojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.processorBuilder);
            closer.push(PojoIdentityMappingCollectorImpl::closeOnFailure, this.identityMappingCollector);
            closer.push(PojoIndexingProcessor::close, this.preBuiltIndexingProcessor);
            this.closed = true;
        }
    }

    PojoMappingCollectorTypeNode asCollector() {
        return this.processorBuilder;
    }

    void preBuild(PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        if (this.preBuiltIndexingProcessor != null) {
            throw new AssertionFailure("Internal error - preBuild should be called only once");
        }
        PojoIndexingDependencyCollectorTypeNode<E> dependencyCollector = reindexingResolverBuildingHelper.createDependencyCollector(this.typeModel);
        this.preBuiltIndexingProcessor = this.processorBuilder.build(dependencyCollector).orElseGet(PojoIndexingProcessor::noOp);
    }

    void buildAndAddTo(PojoIndexedTypeManagerContainer.Builder typeManagersBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper, PojoTypeAdditionalMetadata typeAdditionalMetadata) {
        if (this.preBuiltIndexingProcessor == null) {
            throw new AssertionFailure("Internal error - preBuild should be called before buildAndAddTo");
        }
        this.identityMappingCollector.applyDefaults();
        if (this.identityMappingCollector.documentIdSourceProperty.isPresent()) {
            this.extendedMappingCollector.documentIdSourceProperty(this.identityMappingCollector.documentIdSourceProperty.get());
        }
        this.extendedMappingCollector.identifierMapping(this.identityMappingCollector.identifierMapping);
        PojoPathFilterFactory<Set<String>> pathFilterFactory = typeAdditionalMetadata.getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(this.typeModel)).getPathFilterFactory();
        Optional<PojoImplicitReindexingResolver<E, Set<String>>> reindexingResolverOptional = reindexingResolverBuildingHelper.build(this.typeModel, pathFilterFactory);
        PojoIndexedTypeManager typeManager = new PojoIndexedTypeManager(this.typeModel.getTypeIdentifier(), this.typeModel.getCaster(), this.identityMappingCollector.identifierMapping, this.identityMappingCollector.routingKeyProvider, this.preBuiltIndexingProcessor, this.indexManagerBuilder.build(), reindexingResolverOptional.orElseGet(PojoImplicitReindexingResolver::noOp));
        log.createdPojoIndexedTypeManager(typeManager);
        typeManagersBuilder.add(this.typeModel, typeManager);
        this.closed = true;
    }
}

