/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedPathTracker;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingMapperContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerBuilder;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerFactory;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoAssociationPathInverter;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BridgeResolver;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.spi.ContainerExtractorRegistry;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexModelBinderImpl;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexedTypeManagerBuilder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoMappingDelegateImpl;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoEntityTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoIndexedTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMapper<MPBS extends MappingPartialBuildState>
implements Mapper<MPBS>,
IndexedEntityBindingMapperContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ContextualFailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider;
    private final boolean implicitProvidedId;
    private final boolean multiTenancyEnabled;
    private final FailureHandler failureHandler;
    private final ThreadPoolProvider threadPoolProvider;
    private final PojoMapperDelegate<MPBS> delegate;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final ContainerExtractorBinder extractorBinder;
    private final PojoMappingHelper mappingHelper;
    private final Set<PojoRawTypeModel<?>> entityTypes = new LinkedHashSet();
    private final Set<PojoRawTypeModel<?>> indexedEntityTypes = new LinkedHashSet();
    private final Map<PojoRawTypeModel<?>, PojoIndexedTypeManagerBuilder<?, ?>> indexedTypeManagerBuilders = new LinkedHashMap();
    private final Map<IndexedEmbeddedDefinition, IndexedEmbeddedPathTracker> pathTrackers = new LinkedHashMap<IndexedEmbeddedDefinition, IndexedEmbeddedPathTracker>();
    private boolean closed = false;

    public PojoMapper(MappingBuildContext buildContext, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider, PojoBootstrapIntrospector introspector, ContainerExtractorRegistry containerExtractorRegistry, boolean implicitProvidedId, boolean multiTenancyEnabled, PojoMapperDelegate<MPBS> delegate) {
        this.failureCollector = buildContext.getFailureCollector();
        this.contributorProvider = contributorProvider;
        this.implicitProvidedId = implicitProvidedId;
        this.multiTenancyEnabled = multiTenancyEnabled;
        this.failureHandler = buildContext.getFailureHandler();
        this.threadPoolProvider = buildContext.getThreadPoolProvider();
        this.delegate = delegate;
        this.typeAdditionalMetadataProvider = new PojoTypeAdditionalMetadataProvider(buildContext.getBeanResolver(), (FailureCollector)this.failureCollector, contributorProvider);
        TypePatternMatcherFactory typePatternMatcherFactory = new TypePatternMatcherFactory(introspector);
        this.extractorBinder = new ContainerExtractorBinder(buildContext, containerExtractorRegistry, typePatternMatcherFactory);
        BridgeResolver bridgeResolver = new BridgeResolver(typePatternMatcherFactory);
        PojoIndexModelBinderImpl indexModelBinder = new PojoIndexModelBinderImpl(buildContext, introspector, this.extractorBinder, bridgeResolver, this.typeAdditionalMetadataProvider);
        this.mappingHelper = new PojoMappingHelper((FailureCollector)this.failureCollector, contributorProvider, indexModelBinder);
    }

    public void closeOnFailure() {
        if (!this.closed) {
            this.closed = true;
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManagerBuilder::closeOnFailure, this.indexedTypeManagerBuilders.values());
                closer.push(PojoMapperDelegate::closeOnFailure, this.delegate);
            }
        }
    }

    public void prepareIndexedTypes(Consumer<Optional<String>> backendNameCollector) {
        Set encounteredTypes = this.contributorProvider.getTypesContributedTo();
        for (MappableTypeModel mappableTypeModel : encounteredTypes) {
            try {
                if (!(mappableTypeModel instanceof PojoRawTypeModel)) {
                    throw new AssertionFailure("Expected the mappable type model to be an instance of " + PojoRawTypeModel.class + ", got " + mappableTypeModel + " instead. There is probably a bug in the mapper implementation");
                }
                PojoRawTypeModel rawTypeModel = (PojoRawTypeModel)mappableTypeModel;
                this.prepareEntityOrIndexedType(rawTypeModel, backendNameCollector);
            }
            catch (RuntimeException e) {
                this.failureCollector.withContext(EventContexts.fromType((MappableTypeModel)mappableTypeModel)).add((Throwable)e);
            }
        }
        log.detectedEntityTypes(this.entityTypes, this.indexedEntityTypes);
    }

    private void prepareEntityOrIndexedType(PojoRawTypeModel<?> rawTypeModel, Consumer<Optional<String>> backendNameCollector) {
        Optional<PojoIndexedTypeAdditionalMetadata> indexedTypeMetadataOptional;
        PojoTypeAdditionalMetadata metadata = this.typeAdditionalMetadataProvider.get(rawTypeModel);
        if (metadata.isEntity()) {
            this.entityTypes.add(rawTypeModel);
        }
        if ((indexedTypeMetadataOptional = metadata.getIndexedTypeMetadata()).isPresent()) {
            if (rawTypeModel.isAbstract()) {
                throw log.cannotMapAbstractTypeToIndex(rawTypeModel);
            }
            if (!metadata.getEntityTypeMetadata().isPresent()) {
                throw log.missingEntityTypeMetadata(rawTypeModel);
            }
            PojoIndexedTypeAdditionalMetadata indexedTypeMetadata = indexedTypeMetadataOptional.get();
            backendNameCollector.accept(indexedTypeMetadata.getBackendName());
            this.indexedEntityTypes.add(rawTypeModel);
        }
    }

    public void mapIndexedTypes(MappedIndexManagerFactory indexManagerFactory) {
        for (PojoRawTypeModel<?> indexedEntityType : this.indexedEntityTypes) {
            try {
                this.mapIndexedType(indexedEntityType, indexManagerFactory);
            }
            catch (RuntimeException e) {
                this.failureCollector.withContext(EventContexts.fromType(indexedEntityType)).add((Throwable)e);
            }
        }
        if (!this.failureCollector.hasFailure()) {
            this.checkPathTrackers();
        }
    }

    private void mapIndexedType(PojoRawTypeModel<?> indexedEntityType, MappedIndexManagerFactory indexManagerFactory) {
        PojoTypeAdditionalMetadata metadata = this.typeAdditionalMetadataProvider.get(indexedEntityType);
        PojoIndexedTypeAdditionalMetadata indexedTypeMetadata = metadata.getIndexedTypeMetadata().get();
        PojoEntityTypeAdditionalMetadata entityTypeMetadata = metadata.getEntityTypeMetadata().get();
        String entityName = entityTypeMetadata.getEntityName();
        MappedIndexManagerBuilder indexManagerBuilder = indexManagerFactory.createMappedIndexManager((IndexedEntityBindingMapperContext)this, indexedTypeMetadata.getBackendName(), indexedTypeMetadata.getIndexName().orElse(entityName), entityName, this.multiTenancyEnabled);
        PojoIndexedTypeManagerBuilder builder = this.createIndexedTypeManagerBuilder(indexedEntityType, entityTypeMetadata, indexManagerBuilder);
        this.indexedTypeManagerBuilders.put(indexedEntityType, builder);
        PojoMappingCollectorTypeNode collector = builder.asCollector();
        this.contributorProvider.get(indexedEntityType).forEach(c -> c.contributeMapping(collector));
    }

    public MPBS prepareBuild() throws MappingAbortedException {
        PojoMappingDelegateImpl mappingDelegate;
        PojoIndexedTypeManagerContainer.Builder indexedTypeManagerContainerBuilder = PojoIndexedTypeManagerContainer.builder();
        PojoContainedTypeManagerContainer.Builder containedTypeManagerContainerBuilder = PojoContainedTypeManagerContainer.builder();
        PojoAssociationPathInverter pathInverter = new PojoAssociationPathInverter(this.typeAdditionalMetadataProvider, this.extractorBinder);
        PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper = new PojoImplicitReindexingResolverBuildingHelper(this.extractorBinder, this.typeAdditionalMetadataProvider, pathInverter, this.entityTypes);
        try {
            for (PojoIndexedTypeManagerBuilder<?, ?> pojoIndexedTypeManagerBuilder : this.indexedTypeManagerBuilders.values()) {
                pojoIndexedTypeManagerBuilder.preBuild(reindexingResolverBuildingHelper);
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            for (Map.Entry entry : this.indexedTypeManagerBuilders.entrySet()) {
                PojoRawTypeModel typeModel = (PojoRawTypeModel)entry.getKey();
                PojoIndexedTypeManagerBuilder pojoIndexedTypeManagerBuilder = (PojoIndexedTypeManagerBuilder)entry.getValue();
                try {
                    pojoIndexedTypeManagerBuilder.buildAndAddTo(indexedTypeManagerContainerBuilder, reindexingResolverBuildingHelper, this.typeAdditionalMetadataProvider.get(typeModel));
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(typeModel)).add((Throwable)e);
                }
            }
            for (PojoRawTypeModel pojoRawTypeModel : this.entityTypes) {
                if (pojoRawTypeModel.isAbstract() || this.indexedTypeManagerBuilders.containsKey(pojoRawTypeModel)) continue;
                try {
                    this.buildAndAddContainedTypeManagerTo(containedTypeManagerContainerBuilder, reindexingResolverBuildingHelper, pojoRawTypeModel);
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(pojoRawTypeModel)).add((Throwable)e);
                }
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            mappingDelegate = new PojoMappingDelegateImpl(this.threadPoolProvider, this.failureHandler, indexedTypeManagerContainerBuilder.build(), containedTypeManagerContainerBuilder.build());
        }
        catch (RuntimeException | MappingAbortedException e) {
            ((SuppressingCloser)((SuppressingCloser)((SuppressingCloser)new SuppressingCloser(e).push(PojoImplicitReindexingResolverBuildingHelper::closeOnFailure, (Object)reindexingResolverBuildingHelper)).push(PojoIndexedTypeManagerContainer.Builder::closeOnFailure, (Object)indexedTypeManagerContainerBuilder)).push(PojoContainedTypeManagerContainer.Builder::closeOnFailure, (Object)containedTypeManagerContainerBuilder)).push(PojoMapperDelegate::closeOnFailure, this.delegate);
            throw e;
        }
        this.closed = true;
        try {
            return (MPBS)((MappingPartialBuildState)this.delegate.prepareBuild(mappingDelegate));
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(PojoMapperDelegate::closeOnFailure, this.delegate)).push((AutoCloseable)mappingDelegate);
            throw e;
        }
    }

    public IndexedEmbeddedPathTracker getOrCreatePathTracker(IndexedEmbeddedDefinition definition) {
        return this.pathTrackers.computeIfAbsent(definition, IndexedEmbeddedPathTracker::new);
    }

    private void checkPathTrackers() {
        for (Map.Entry<IndexedEmbeddedDefinition, IndexedEmbeddedPathTracker> entry : this.pathTrackers.entrySet()) {
            IndexedEmbeddedPathTracker pathTracker = entry.getValue();
            Set uselessIncludePaths = pathTracker.getUselessIncludePaths();
            if (uselessIncludePaths.isEmpty()) continue;
            Set encounteredFieldPaths = pathTracker.getEncounteredFieldPaths();
            this.failureCollector.add((Throwable)log.uselessIncludePathFilters(uselessIncludePaths, encounteredFieldPaths, EventContexts.fromType((MappableTypeModel)entry.getKey().getDefiningTypeModel())));
        }
    }

    private <T> void buildAndAddContainedTypeManagerTo(PojoContainedTypeManagerContainer.Builder containedTypeManagerContainerBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper, PojoRawTypeModel<T> entityType) {
        PojoEntityTypeAdditionalMetadata entityTypeMetadata = this.typeAdditionalMetadataProvider.get(entityType).getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(entityType));
        PojoPathFilterFactory<Set<String>> pathFilterFactory = entityTypeMetadata.getPathFilterFactory();
        Optional<PojoImplicitReindexingResolver<T, Set<String>>> reindexingResolverOptional = reindexingResolverBuildingHelper.build(entityType, pathFilterFactory);
        if (reindexingResolverOptional.isPresent()) {
            this.delegate.createContainedTypeExtendedMappingCollector(entityType, entityTypeMetadata.getEntityName());
            PojoContainedTypeManager<T> typeManager = new PojoContainedTypeManager<T>(entityType.getTypeIdentifier(), entityType.getCaster(), reindexingResolverOptional.get());
            log.createdPojoContainedTypeManager(typeManager);
            containedTypeManagerContainerBuilder.add(entityType, typeManager);
        }
    }

    private <E, D extends DocumentElement> PojoIndexedTypeManagerBuilder<E, D> createIndexedTypeManagerBuilder(PojoRawTypeModel<E> entityTypeModel, PojoEntityTypeAdditionalMetadata entityTypeMetadata, MappedIndexManagerBuilder<D> indexManagerBuilder) {
        return new PojoIndexedTypeManagerBuilder<E, D>(entityTypeModel, entityTypeMetadata, this.mappingHelper, indexManagerBuilder, this.delegate.createIndexedTypeExtendedMappingCollector(entityTypeModel, entityTypeMetadata.getEntityName(), indexManagerBuilder.getIndexName()), this.implicitProvidedId);
    }
}

