/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataDiscoverer;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationPojoTypeMetadataContributorFactory;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.reflect.spi.AnnotationHelper;

public class AnnotationMappingConfigurationContextImpl
implements AnnotationMappingConfigurationContext,
PojoMappingConfigurationContributor {
    private final PojoBootstrapIntrospector introspector;
    private final Set<Class<?>> annotatedTypes = new LinkedHashSet();
    private boolean annotatedTypeDiscoveryEnabled = false;

    public AnnotationMappingConfigurationContextImpl(PojoBootstrapIntrospector introspector) {
        this.introspector = introspector;
    }

    public void setAnnotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.annotatedTypeDiscoveryEnabled = annotatedTypeDiscoveryEnabled;
    }

    @Override
    public AnnotationMappingConfigurationContext add(Class<?> annotatedType) {
        this.annotatedTypes.add(annotatedType);
        return this;
    }

    @Override
    public AnnotationMappingConfigurationContext add(Set<Class<?>> annotatedTypes) {
        this.annotatedTypes.addAll(annotatedTypes);
        return this;
    }

    @Override
    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> collector) {
        BeanResolver beanResolver = buildContext.getBeanResolver();
        ContextualFailureCollector failureCollector = buildContext.getFailureCollector();
        AnnotationHelper annotationHelper = new AnnotationHelper(this.introspector.getAnnotationValueReadHandleFactory());
        AnnotationPojoTypeMetadataContributorFactory contributorFactory = new AnnotationPojoTypeMetadataContributorFactory(beanResolver, (FailureCollector)failureCollector, annotationHelper);
        HashSet alreadyContributedTypes = new HashSet();
        this.annotatedTypes.stream().map(this.introspector::getTypeModel).flatMap(PojoRawTypeModel::getAscendingSuperTypes).filter(alreadyContributedTypes::add).forEach(typeModel -> {
            Optional<PojoTypeMetadataContributor> contributorOptional = contributorFactory.createIfAnnotated((PojoRawTypeModel<?>)typeModel);
            if (contributorOptional.isPresent()) {
                collector.collectContributor((MappableTypeModel)typeModel, (Object)contributorOptional.get());
            }
        });
        if (this.annotatedTypeDiscoveryEnabled) {
            PojoAnnotationTypeMetadataDiscoverer discoverer = new PojoAnnotationTypeMetadataDiscoverer(contributorFactory, alreadyContributedTypes);
            collector.collectDiscoverer((TypeMetadataDiscoverer)discoverer);
        }
    }

    private static class PojoAnnotationTypeMetadataDiscoverer
    implements TypeMetadataDiscoverer<PojoTypeMetadataContributor> {
        private final AnnotationPojoTypeMetadataContributorFactory contributorFactory;
        private final Set<PojoRawTypeModel<?>> alreadyContributedTypes;

        PojoAnnotationTypeMetadataDiscoverer(AnnotationPojoTypeMetadataContributorFactory contributorFactory, Set<PojoRawTypeModel<?>> alreadyContributedTypes) {
            this.contributorFactory = contributorFactory;
            this.alreadyContributedTypes = alreadyContributedTypes;
        }

        public Optional<PojoTypeMetadataContributor> discover(MappableTypeModel typeModel) {
            PojoRawTypeModel pojoTypeModel = (PojoRawTypeModel)typeModel;
            boolean neverContributed = this.alreadyContributedTypes.add(pojoTypeModel);
            if (neverContributed) {
                return this.contributorFactory.createIfAnnotated(pojoTypeModel);
            }
            return Optional.empty();
        }
    }
}

