/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Date;
import java.time.Instant;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaSqlDateValueBridge
implements ValueBridge<Date, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Instant toIndexedValue(Date value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : Instant.ofEpochMilli(value.getTime());
    }

    @Override
    public Date fromIndexedValue(Instant value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : new Date(value.toEpochMilli());
    }

    @Override
    public Instant parse(String value) {
        return ParseUtils.parseInstant((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }
}

