/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.util.common.impl.Closer;

public class PojoIndexedTypeManagerContainer
implements PojoWorkIndexedTypeContextProvider,
PojoScopeIndexedTypeContextProvider {
    private final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeManager<?, ?, ?>> byExactType;
    private final Map<PojoRawTypeIdentifier<?>, Set<? extends PojoIndexedTypeManager<?, ?, ?>>> bySuperType;
    private final Set<PojoIndexedTypeManager<?, ?, ?>> all;

    public static Builder builder() {
        return new Builder();
    }

    private PojoIndexedTypeManagerContainer(Builder builder) {
        this.byExactType = new HashMap(builder.byExactType);
        this.bySuperType = new HashMap(builder.bySuperType);
        this.bySuperType.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.all = Collections.unmodifiableSet(new LinkedHashSet(this.byExactType.values()));
    }

    @Override
    public <E> Optional<? extends PojoWorkIndexedTypeContext<?, E, ?>> getByExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return Optional.ofNullable(this.byExactType.get(typeIdentifier));
    }

    @Override
    public <E> Optional<? extends Set<? extends PojoScopeIndexedTypeContext<?, ? extends E, ?>>> getAllBySuperType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return Optional.ofNullable(this.bySuperType.get(typeIdentifier));
    }

    Set<PojoIndexedTypeManager<?, ?, ?>> getAll() {
        return this.all;
    }

    public static class Builder {
        private final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeManager<?, ?, ?>> byExactType = new LinkedHashMap();
        private final Map<PojoRawTypeIdentifier<?>, Set<PojoIndexedTypeManager<?, ?, ?>>> bySuperType = new LinkedHashMap();

        private Builder() {
        }

        public <E> void add(PojoRawTypeModel<E> typeModel, PojoIndexedTypeManager<?, E, ?> typeManager) {
            this.byExactType.put(typeModel.getTypeIdentifier(), typeManager);
            typeModel.getAscendingSuperTypes().map(PojoRawTypeModel::getTypeIdentifier).forEach(clazz -> this.bySuperType.computeIfAbsent((PojoRawTypeIdentifier<?>)clazz, ignored -> new LinkedHashSet()).add(typeManager));
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManager::close, this.byExactType.values());
            }
        }

        public PojoIndexedTypeManagerContainer build() {
            return new PojoIndexedTypeManagerContainer(this);
        }
    }
}

