/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.IdentifierBridgeToDocumentIdentifierContextImpl;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.ValueBridgeToIndexedValueContextImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.Closer;

public abstract class AbstractPojoMappingImplementor<M>
implements MappingImplementor<M>,
PojoScopeMappingContext,
PojoSearchSessionMappingContext {
    private final PojoMappingDelegate delegate;
    private final List<CloseDelegate> closeDelegates = new ArrayList<CloseDelegate>();
    private boolean closed = false;
    private final IdentifierBridgeToDocumentIdentifierContext toDocumentIdentifierContext;
    private final ValueBridgeToIndexedValueContext toIndexedValueContext;

    public AbstractPojoMappingImplementor(PojoMappingDelegate delegate) {
        this.delegate = delegate;
        this.toDocumentIdentifierContext = new IdentifierBridgeToDocumentIdentifierContextImpl(this);
        this.toIndexedValueContext = new ValueBridgeToIndexedValueContextImpl(this);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try (Closer closer = new Closer();){
                closer.push(PojoMappingDelegate::close, (Object)this.delegate);
                closer.pushAll(CloseDelegate::close, this.closeDelegates);
            }
        }
    }

    @Override
    public final IdentifierBridgeToDocumentIdentifierContext getIdentifierBridgeToDocumentIdentifierContext() {
        return this.toDocumentIdentifierContext;
    }

    @Override
    public ValueBridgeToIndexedValueContext getValueBridgeToIndexedValueContext() {
        return this.toIndexedValueContext;
    }

    @Override
    public PojoIndexingPlan createIndexingPlan(PojoWorkSessionContext context, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.delegate.createIndexingPlan(context, commitStrategy, refreshStrategy);
    }

    @Override
    public PojoIndexer createIndexer(PojoWorkSessionContext context, DocumentCommitStrategy commitStrategy) {
        return this.delegate.createIndexer(context, commitStrategy);
    }

    protected final PojoMappingDelegate getDelegate() {
        return this.delegate;
    }

    public void onClose(CloseDelegate closeable) {
        this.closeDelegates.add(closeable);
    }

    public static interface CloseDelegate
    extends AutoCloseable {
        @Override
        public void close();
    }
}

