/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;

public class PojoScopeWorkspaceImpl
implements PojoScopeWorkspace {
    private final List<IndexWorkspace> delegates = new ArrayList<IndexWorkspace>();

    public PojoScopeWorkspaceImpl(Set<? extends PojoWorkIndexedTypeContext<?, ?, ?>> targetedTypeContexts, DetachedBackendSessionContext sessionContext) {
        for (PojoWorkIndexedTypeContext<?, ?, ?> targetedTypeContext : targetedTypeContexts) {
            this.delegates.add(targetedTypeContext.createWorkspace(sessionContext));
        }
    }

    @Override
    public CompletableFuture<?> mergeSegments() {
        return this.doOperationOnTypes(IndexWorkspace::mergeSegments);
    }

    @Override
    public CompletableFuture<?> purge() {
        return this.doOperationOnTypes(IndexWorkspace::purge);
    }

    @Override
    public CompletableFuture<?> flush() {
        return this.doOperationOnTypes(IndexWorkspace::flush);
    }

    private CompletableFuture<?> doOperationOnTypes(Function<IndexWorkspace, CompletableFuture<?>> operation) {
        CompletableFuture[] futures = new CompletableFuture[this.delegates.size()];
        int typeCounter = 0;
        for (IndexWorkspace delegate : this.delegates) {
            futures[typeCounter++] = operation.apply(delegate);
        }
        return CompletableFuture.allOf(futures);
    }
}

