/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Time;
import java.time.Instant;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaSqlTimeValueBridge
implements ValueBridge<Time, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Instant toIndexedValue(Time value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : Instant.ofEpochMilli(value.getTime());
    }

    @Override
    public Time fromIndexedValue(Instant value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : new Time(value.toEpochMilli());
    }

    @Override
    public Instant parse(String value) {
        return ParseUtils.parseInstant((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }
}

