/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path;

import java.util.Objects;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.util.common.impl.Contracts;

public final class PojoModelPathValueNode
extends PojoModelPath {
    private final PojoModelPathPropertyNode parent;
    private final ContainerExtractorPath extractorPath;

    PojoModelPathValueNode(PojoModelPathPropertyNode parent, ContainerExtractorPath extractorPath) {
        Contracts.assertNotNull((Object)parent, (String)"parent");
        Contracts.assertNotNull((Object)extractorPath, (String)"extractorPath");
        this.parent = parent;
        this.extractorPath = extractorPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoModelPathValueNode that = (PojoModelPathValueNode)o;
        return this.parent.equals(that.parent) && Objects.equals(this.extractorPath, that.extractorPath);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.extractorPath);
    }

    @Override
    public PojoModelPathPropertyNode getParent() {
        return this.parent;
    }

    public ContainerExtractorPath getExtractorPath() {
        return this.extractorPath;
    }

    public PojoModelPathPropertyNode property(String propertyName) {
        return new PojoModelPathPropertyNode(this, propertyName);
    }

    @Override
    void appendSelfPath(StringBuilder builder) {
        builder.append(this.getExtractorPath());
    }
}

