/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DefaultJavaNetURLValueBridge
implements ValueBridge<URL, String> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toIndexedValue(URL value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.toExternalForm();
    }

    @Override
    public URL fromIndexedValue(String value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : DefaultJavaNetURLValueBridge.toURL(value);
    }

    @Override
    public String parse(String value) {
        if (value == null) {
            return null;
        }
        DefaultJavaNetURLValueBridge.toURL(value);
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static URL toURL(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw log.malformedURL(value, e);
        }
    }
}

