/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.MarkerBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.PropertyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.RoutingKeyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;

public final class BeanDelegatingBinder
implements TypeBinder,
PropertyBinder,
RoutingKeyBinder,
MarkerBinder,
IdentifierBinder,
ValueBinder {
    private final BeanReference<?> delegateReference;

    public BeanDelegatingBinder(BeanReference<?> delegateReference) {
        this.delegateReference = delegateReference;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + "]";
    }

    @Override
    public void bind(TypeBindingContext context) {
        try (BeanHolder<TypeBinder> delegateHolder = this.createDelegate(context.beanResolver(), TypeBinder.class);){
            ((TypeBinder)delegateHolder.get()).bind(context);
        }
    }

    @Override
    public void bind(PropertyBindingContext context) {
        try (BeanHolder<PropertyBinder> delegateHolder = this.createDelegate(context.beanResolver(), PropertyBinder.class);){
            ((PropertyBinder)delegateHolder.get()).bind(context);
        }
    }

    @Override
    public void bind(RoutingKeyBindingContext context) {
        try (BeanHolder<RoutingKeyBinder> delegateHolder = this.createDelegate(context.beanResolver(), RoutingKeyBinder.class);){
            ((RoutingKeyBinder)delegateHolder.get()).bind(context);
        }
    }

    @Override
    public void bind(MarkerBindingContext context) {
        try (BeanHolder<MarkerBinder> delegateHolder = this.createDelegate(context.beanResolver(), MarkerBinder.class);){
            ((MarkerBinder)delegateHolder.get()).bind(context);
        }
    }

    @Override
    public void bind(IdentifierBindingContext<?> context) {
        try (BeanHolder<IdentifierBinder> delegateHolder = this.createDelegate(context.beanResolver(), IdentifierBinder.class);){
            ((IdentifierBinder)delegateHolder.get()).bind(context);
        }
    }

    @Override
    public void bind(ValueBindingContext<?> context) {
        try (BeanHolder<ValueBinder> delegateHolder = this.createDelegate(context.beanResolver(), ValueBinder.class);){
            ((ValueBinder)delegateHolder.get()).bind(context);
        }
    }

    private <B> BeanHolder<? extends B> createDelegate(BeanResolver beanResolver, Class<B> expectedType) {
        return this.delegateReference.asSubTypeOf(expectedType).resolve(beanResolver);
    }
}

