/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.RoutingKeyProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.CachingCastingEntitySupplier;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentContributor;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentReferenceProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexer;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeAppendable;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexedTypeManager<I, E>
implements AutoCloseable,
ToStringTreeAppendable,
PojoWorkIndexedTypeContext<I, E>,
PojoScopeIndexedTypeContext<I, E> {
    private final PojoRawTypeIdentifier<E> typeIdentifier;
    private final PojoCaster<E> caster;
    private final IdentifierMappingImplementor<I, E> identifierMapping;
    private final RoutingKeyProvider<E> routingKeyProvider;
    private final PojoIndexingProcessor<E> processor;
    private final MappedIndexManager indexManager;
    private final PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver;

    public PojoIndexedTypeManager(PojoRawTypeIdentifier<E> typeIdentifier, PojoCaster<E> caster, IdentifierMappingImplementor<I, E> identifierMapping, RoutingKeyProvider<E> routingKeyProvider, PojoIndexingProcessor<E> processor, MappedIndexManager indexManager, PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver) {
        this.typeIdentifier = typeIdentifier;
        this.caster = caster;
        this.identifierMapping = identifierMapping;
        this.routingKeyProvider = routingKeyProvider;
        this.processor = processor;
        this.indexManager = indexManager;
        this.reindexingResolver = reindexingResolver;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[javaType = " + this.typeIdentifier + "]";
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierMappingImplementor::close, this.identifierMapping);
            closer.push(RoutingKeyProvider::close, this.routingKeyProvider);
            closer.push(PojoIndexingProcessor::close, this.processor);
            closer.push(PojoImplicitReindexingResolver::close, this.reindexingResolver);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("typeIdentifier", this.typeIdentifier).attribute("indexManager", (Object)this.indexManager).attribute("identifierMapping", this.identifierMapping).attribute("routingKeyProvider", this.routingKeyProvider).attribute("processor", this.processor).attribute("reindexingResolver", this.reindexingResolver);
    }

    @Override
    public PojoRawTypeIdentifier<E> getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public IdentifierMappingImplementor<I, E> getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public Supplier<E> toEntitySupplier(PojoWorkSessionContext<?> sessionContext, Object entity) {
        PojoRuntimeIntrospector introspector = sessionContext.runtimeIntrospector();
        return new CachingCastingEntitySupplier<E>(this.caster, introspector, entity);
    }

    @Override
    public DocumentReferenceProvider toDocumentReferenceProvider(PojoWorkSessionContext<?> sessionContext, I identifier, Supplier<E> entitySupplier) {
        String documentIdentifier = this.identifierMapping.toDocumentIdentifier(identifier, sessionContext.mappingContext());
        String routingKey = this.routingKeyProvider.toRoutingKey(identifier, entitySupplier, sessionContext);
        return new PojoDocumentReferenceProvider(documentIdentifier, routingKey, identifier);
    }

    @Override
    public DocumentReferenceProvider toDocumentReferenceProvider(PojoWorkSessionContext<?> sessionContext, I identifier, String providedRoutingKey) {
        String documentIdentifier = this.identifierMapping.toDocumentIdentifier(identifier, sessionContext.mappingContext());
        return new PojoDocumentReferenceProvider(documentIdentifier, providedRoutingKey, identifier);
    }

    @Override
    public PojoDocumentContributor<E> toDocumentContributor(Supplier<E> entitySupplier, PojoWorkSessionContext<?> sessionContext) {
        return new PojoDocumentContributor<E>(this.processor, sessionContext, entitySupplier);
    }

    @Override
    public boolean requiresSelfReindexing(Set<String> dirtyPaths) {
        return this.reindexingResolver.requiresSelfReindexing(dirtyPaths);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, Supplier<E> entitySupplier, Set<String> dirtyPaths) {
        this.reindexingResolver.resolveEntitiesToReindex(collector, runtimeIntrospector, entitySupplier.get(), dirtyPaths);
    }

    @Override
    public IndexSchemaManager getSchemaManager() {
        return this.indexManager.schemaManager();
    }

    @Override
    public PojoTypeIndexer<I, E> createIndexer(PojoWorkSessionContext<?> sessionContext) {
        return new PojoTypeIndexer(this, sessionContext, this.indexManager.createIndexer(sessionContext));
    }

    @Override
    public IndexWorkspace createWorkspace(DetachedBackendSessionContext sessionContext) {
        return this.indexManager.createWorkspace(sessionContext);
    }

    @Override
    public <R> PojoIndexedTypeIndexingPlan<I, E, R> createIndexingPlan(PojoWorkSessionContext<R> sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return new PojoIndexedTypeIndexingPlan(this, sessionContext, this.indexManager.createIndexingPlan(sessionContext, sessionContext.entityReferenceFactory(), commitStrategy, refreshStrategy));
    }

    @Override
    public <R, E2> MappedIndexScopeBuilder<R, E2> createScopeBuilder(BackendMappingContext mappingContext) {
        return this.indexManager.createScopeBuilder(mappingContext);
    }

    @Override
    public void addTo(MappedIndexScopeBuilder<?, ?> builder) {
        this.indexManager.addTo(builder);
    }
}

