/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.scope.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScope;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.schema.management.impl.PojoScopeSchemaManagerImpl;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeTypeExtendedContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoScopeWorkspaceImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoScopeDelegateImpl<R, E, E2, C>
implements PojoScopeDelegate<R, E2, C> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoScopeMappingContext mappingContext;
    private final Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>> targetedTypeContexts;
    private final Set<C> targetedTypeExtendedContexts;
    private MappedIndexScope<R, E2> delegate;

    public static <R, E, E2, C> PojoScopeDelegate<R, E2, C> create(PojoScopeMappingContext mappingContext, PojoScopeIndexedTypeContextProvider indexedTypeContextProvider, PojoScopeContainedTypeContextProvider containedTypeContextProvider, Collection<? extends PojoRawTypeIdentifier<? extends E>> targetedTypes, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider) {
        if (targetedTypes.isEmpty()) {
            throw log.invalidEmptyTargetForScope();
        }
        LinkedHashSet targetedTypeContexts = new LinkedHashSet();
        LinkedHashSet nonIndexedTypes = new LinkedHashSet();
        LinkedHashSet nonIndexedButContainedTypes = new LinkedHashSet();
        for (PojoRawTypeIdentifier<E> pojoRawTypeIdentifier : targetedTypes) {
            Optional<Set<PojoScopeIndexedTypeContext<?, E>>> targetedTypeManagersForType = indexedTypeContextProvider.getAllBySuperType(pojoRawTypeIdentifier);
            if (targetedTypeManagersForType.isPresent()) {
                targetedTypeContexts.addAll(targetedTypeManagersForType.get());
                continue;
            }
            nonIndexedTypes.add(pojoRawTypeIdentifier);
            if (!containedTypeContextProvider.getByExactType(pojoRawTypeIdentifier).isPresent()) continue;
            nonIndexedButContainedTypes.add(pojoRawTypeIdentifier);
        }
        if (!nonIndexedTypes.isEmpty() || !nonIndexedButContainedTypes.isEmpty()) {
            throw log.invalidScopeTarget(nonIndexedTypes, nonIndexedButContainedTypes);
        }
        Set targetedTypeExtendedContexts = targetedTypeContexts.stream().map(PojoWorkIndexedTypeContext::getTypeIdentifier).map(indexedTypeExtendedContextProvider::forExactType).collect(Collectors.toCollection(LinkedHashSet::new));
        return new PojoScopeDelegateImpl<R, E, E2, C>(mappingContext, targetedTypeContexts, targetedTypeExtendedContexts);
    }

    private PojoScopeDelegateImpl(PojoScopeMappingContext mappingContext, Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>> targetedTypeContexts, Set<C> targetedTypeExtendedContexts) {
        this.mappingContext = mappingContext;
        this.targetedTypeContexts = targetedTypeContexts;
        this.targetedTypeExtendedContexts = targetedTypeExtendedContexts;
    }

    @Override
    public Set<C> includedIndexedTypes() {
        return this.targetedTypeExtendedContexts;
    }

    @Override
    public <LOS> SearchQuerySelectStep<?, R, E2, LOS, SearchProjectionFactory<R, E2>, ?> search(BackendSessionContext sessionContext, LoadingContextBuilder<R, E2, LOS> loadingContextBuilder) {
        return this.getIndexScope().search(sessionContext, loadingContextBuilder);
    }

    @Override
    public SearchPredicateFactory predicate() {
        return this.getIndexScope().predicate();
    }

    @Override
    public SearchSortFactory sort() {
        return this.getIndexScope().sort();
    }

    @Override
    public SearchProjectionFactory<R, E2> projection() {
        return this.getIndexScope().projection();
    }

    @Override
    public SearchAggregationFactory aggregation() {
        return this.getIndexScope().aggregation();
    }

    @Override
    public PojoScopeWorkspace workspace(DetachedBackendSessionContext sessionContext) {
        return new PojoScopeWorkspaceImpl(this.targetedTypeContexts, sessionContext);
    }

    @Override
    public PojoScopeSchemaManager schemaManager() {
        return new PojoScopeSchemaManagerImpl(this.targetedTypeContexts);
    }

    private MappedIndexScope<R, E2> getIndexScope() {
        if (this.delegate == null) {
            Iterator<PojoScopeIndexedTypeContext<?, E>> iterator = this.targetedTypeContexts.iterator();
            MappedIndexScopeBuilder builder = iterator.next().createScopeBuilder(this.mappingContext);
            while (iterator.hasNext()) {
                iterator.next().addTo(builder);
            }
            this.delegate = builder.build();
        }
        return this.delegate;
    }
}

