/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingPlanImpl<R>
implements PojoIndexingPlan<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkIndexedTypeContextProvider indexedTypeContextProvider;
    private final PojoWorkContainedTypeContextProvider containedTypeContextProvider;
    private final PojoWorkSessionContext<R> sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeIndexingPlan<?, ?, R>> indexedTypeDelegates = new LinkedHashMap();
    private final Map<PojoRawTypeIdentifier<?>, PojoContainedTypeIndexingPlan<?>> containedTypeDelegates = new LinkedHashMap();
    private boolean isProcessing = false;

    public PojoIndexingPlanImpl(PojoWorkIndexedTypeContextProvider indexedTypeContextProvider, PojoWorkContainedTypeContextProvider containedTypeContextProvider, PojoWorkSessionContext<R> sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.containedTypeContextProvider = containedTypeContextProvider;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.runtimeIntrospector();
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    @Override
    public void add(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, Object entity) {
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(typeIdentifier);
        delegate.add(providedId, entity);
    }

    @Override
    public void addOrUpdate(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, Object entity) {
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(typeIdentifier);
        delegate.update(providedId, entity);
    }

    @Override
    public void addOrUpdate(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, Object entity, String ... dirtyPaths) {
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(typeIdentifier);
        delegate.update(providedId, entity, dirtyPaths);
    }

    @Override
    public void delete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, Object entity) {
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(typeIdentifier);
        delegate.delete(providedId, entity);
    }

    @Override
    public void purge(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, String providedRoutingKey) {
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(typeIdentifier);
        delegate.purge(providedId, providedRoutingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.isProcessing) {
            throw log.recursiveIndexingPlanProcess();
        }
        this.isProcessing = true;
        try {
            for (PojoContainedTypeIndexingPlan<?> delegate : this.containedTypeDelegates.values()) {
                delegate.resolveDirty(this::updateBecauseOfContained);
            }
            ArrayList frozenIndexedTypeDelegates = new ArrayList(this.indexedTypeDelegates.values());
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : frozenIndexedTypeDelegates) {
                pojoIndexedTypeIndexingPlan.resolveDirty(this::updateBecauseOfContained);
            }
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                pojoIndexedTypeIndexingPlan.process();
            }
        }
        finally {
            this.isProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<IndexIndexingPlanExecutionReport<R>> executeAndReport() {
        try {
            this.process();
            ArrayList<CompletableFuture<IndexIndexingPlanExecutionReport<R>>> futures = new ArrayList<CompletableFuture<IndexIndexingPlanExecutionReport<R>>>();
            for (PojoIndexedTypeIndexingPlan<?, ?, R> delegate : this.indexedTypeDelegates.values()) {
                futures.add(delegate.executeAndReport());
            }
            CompletableFuture completableFuture = IndexIndexingPlanExecutionReport.allOf(futures);
            return completableFuture;
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discard() {
        try {
            for (PojoIndexedTypeIndexingPlan<?, ?, R> delegate : this.indexedTypeDelegates.values()) {
                delegate.discard();
            }
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discardNotProcessed() {
        for (PojoIndexedTypeIndexingPlan<?, ?, R> delegate : this.indexedTypeDelegates.values()) {
            delegate.discardNotProcessed();
        }
    }

    private PojoRuntimeIntrospector getIntrospector() {
        return this.introspector;
    }

    private AbstractPojoTypeIndexingPlan getDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        AbstractPojoTypeIndexingPlan delegate = this.indexedTypeDelegates.get(typeIdentifier);
        if (delegate == null && (delegate = (AbstractPojoTypeIndexingPlan)this.containedTypeDelegates.get(typeIdentifier)) == null) {
            delegate = this.createDelegate(typeIdentifier);
        }
        return delegate;
    }

    private AbstractPojoTypeIndexingPlan createDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        Optional<PojoWorkIndexedTypeContext<?, ?>> indexedTypeContextOptional = this.indexedTypeContextProvider.getByExactType(typeIdentifier);
        if (indexedTypeContextOptional.isPresent()) {
            PojoIndexedTypeIndexingPlan<?, ?, R> delegate = indexedTypeContextOptional.get().createIndexingPlan(this.sessionContext, this.commitStrategy, this.refreshStrategy);
            this.indexedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        Optional<PojoWorkContainedTypeContext<?>> containedTypeContextOptional = this.containedTypeContextProvider.getByExactType(typeIdentifier);
        if (containedTypeContextOptional.isPresent()) {
            PojoContainedTypeIndexingPlan<?> delegate = containedTypeContextOptional.get().createIndexingPlan(this.sessionContext);
            this.containedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        throw log.notIndexedTypeNorAsDelegate(typeIdentifier);
    }

    private PojoIndexedTypeIndexingPlan<?, ?, ?> getOrCreateIndexedDelegateForContainedUpdate(PojoRawTypeIdentifier<?> typeIdentifier) {
        PojoIndexedTypeIndexingPlan<?, ?, R> delegate = this.indexedTypeDelegates.get(typeIdentifier);
        if (delegate != null) {
            return delegate;
        }
        Optional<PojoWorkIndexedTypeContext<?, ?>> indexedTypeManagerOptional = this.indexedTypeContextProvider.getByExactType(typeIdentifier);
        if (indexedTypeManagerOptional.isPresent()) {
            delegate = indexedTypeManagerOptional.get().createIndexingPlan(this.sessionContext, this.commitStrategy, this.refreshStrategy);
            this.indexedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        throw new AssertionFailure("Attempt to reindex an entity of type " + typeIdentifier + " because a contained entity was modified, but this entity type is not indexed directly. There is a bug in Hibernate Search, please report it.");
    }

    private void updateBecauseOfContained(Object containingEntity) {
        PojoRawTypeIdentifier<Object> typeIdentifier = this.getIntrospector().detectEntityType(containingEntity);
        if (typeIdentifier == null) {
            throw new AssertionFailure("Attempt to reindex entity " + containingEntity + " because a contained entity was modified, but this entity type is not indexed directly. There is a bug in Hibernate Search, please report it.");
        }
        PojoIndexedTypeIndexingPlan<Object, Object, Object> delegate = this.getOrCreateIndexedDelegateForContainedUpdate(typeIdentifier);
        delegate.updateBecauseOfContained(containingEntity);
    }
}

