/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorConfigurationContext;
import org.hibernate.search.mapper.pojo.extractor.builtin.BuiltinContainerExtractors;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.ArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.CollectionElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.IterableElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.MapKeyExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.MapValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalDoubleValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalIntValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalLongValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.impl.OptionalValueExtractor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ContainerExtractorRegistry {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, Class<? extends ContainerExtractor>> extractorsByName = new HashMap<String, Class<? extends ContainerExtractor>>();
    private final List<String> defaultExtractors = new ArrayList<String>();

    public static Builder builder() {
        return new Builder();
    }

    private ContainerExtractorRegistry(Map<String, Class<? extends ContainerExtractor>> customExtractorsByName) {
        this.extractorsByName.putAll(customExtractorsByName);
        this.addDefaultExtractor("map-value", MapValueExtractor.class);
        this.addDefaultExtractor("collection", CollectionElementExtractor.class);
        this.addDefaultExtractor("iterable", IterableElementExtractor.class);
        this.addDefaultExtractor("optional", OptionalValueExtractor.class);
        this.addDefaultExtractor("optional-int", OptionalIntValueExtractor.class);
        this.addDefaultExtractor("optional-long", OptionalLongValueExtractor.class);
        this.addDefaultExtractor("optional-double", OptionalDoubleValueExtractor.class);
        this.addDefaultExtractor("array", ArrayElementExtractor.class);
        this.addNonDefaultExtractor("map-key", MapKeyExtractor.class);
    }

    public List<String> defaults() {
        return Collections.unmodifiableList(this.defaultExtractors);
    }

    public Class<? extends ContainerExtractor> forName(String name) {
        Class<? extends ContainerExtractor> result = this.extractorsByName.get(name);
        if (result == null) {
            throw log.cannotResolveContainerExtractorName(name, BuiltinContainerExtractors.class);
        }
        return result;
    }

    private void addDefaultExtractor(String name, Class<? extends ContainerExtractor> extractorClass) {
        this.extractorsByName.put(name, extractorClass);
        this.defaultExtractors.add(name);
    }

    private void addNonDefaultExtractor(String name, Class<? extends ContainerExtractor> extractorClass) {
        this.extractorsByName.put(name, extractorClass);
    }

    public static final class Builder
    implements ContainerExtractorConfigurationContext {
        private final Map<String, Class<? extends ContainerExtractor>> extractorsByName = new HashMap<String, Class<? extends ContainerExtractor>>();

        private Builder() {
        }

        @Override
        public void define(String extractorName, Class<? extends ContainerExtractor> extractorClass) {
            this.extractorsByName.put(extractorName, extractorClass);
        }

        public ContainerExtractorRegistry build() {
            return new ContainerExtractorRegistry(this.extractorsByName);
        }
    }
}

