/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.PropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.ProvidedIdentifierMapping;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.RoutingKeyBridgeRoutingKeyProvider;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.RoutingKeyProvider;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoEntityTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIdentityMappingCollector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIdentityMappingCollectorImpl<E>
implements PojoIdentityMappingCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeModel<E> typeModel;
    private final PojoMappingHelper mappingHelper;
    private final IndexedEntityBindingContext bindingContext;
    private final BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge;
    private final BeanResolver beanResolver;
    private final BoundPojoModelPathPropertyNode<?, ?> entityIdPropertyPath;
    IdentifierMappingImplementor<?, E> identifierMapping;
    Optional<PojoPropertyModel<?>> documentIdSourceProperty;
    RoutingKeyProvider<E> routingKeyProvider;

    PojoIdentityMappingCollectorImpl(PojoRawTypeModel<E> typeModel, PojoEntityTypeAdditionalMetadata entityTypeMetadata, PojoMappingHelper mappingHelper, IndexedEntityBindingContext bindingContext, BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge, BeanResolver beanResolver) {
        this.typeModel = typeModel;
        this.mappingHelper = mappingHelper;
        this.bindingContext = bindingContext;
        this.providedIdentifierBridge = providedIdentifierBridge;
        this.beanResolver = beanResolver;
        Optional<String> entityIdPropertyName = entityTypeMetadata.getEntityIdPropertyName();
        this.entityIdPropertyPath = entityIdPropertyName.isPresent() ? BoundPojoModelPath.root(typeModel).property(entityIdPropertyName.get()) : null;
    }

    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierMappingImplementor::close, this.identifierMapping);
            closer.push(RoutingKeyProvider::close, this.routingKeyProvider);
        }
    }

    @Override
    public <T> void identifierBridge(BoundPojoModelPathPropertyNode<?, T> modelPath, IdentifierBinder binder) {
        BoundIdentifierBridge<T> boundIdentifierBridge = this.mappingHelper.getIndexModelBinder().bindIdentifier(this.bindingContext, modelPath, binder);
        PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
        this.identifierMapping = new PropertyIdentifierMapping(propertyModel.typeModel().rawType().caster(), propertyModel.handle(), boundIdentifierBridge.getBridgeHolder());
        this.documentIdSourceProperty = Optional.of(propertyModel);
    }

    @Override
    public <T> BoundRoutingKeyBridge<T> routingKeyBridge(BoundPojoModelPathTypeNode<T> modelPath, RoutingKeyBinder binder) {
        BoundRoutingKeyBridge<T> boundRoutingKeyBridge = this.mappingHelper.getIndexModelBinder().bindRoutingKey(this.bindingContext, modelPath, binder);
        this.routingKeyProvider = new RoutingKeyBridgeRoutingKeyProvider(boundRoutingKeyBridge.getBridgeHolder());
        return boundRoutingKeyBridge;
    }

    void applyDefaults() {
        if (this.identifierMapping == null) {
            if (this.providedIdentifierBridge != null) {
                this.identifierMapping = ProvidedIdentifierMapping.get((BeanHolder<? extends IdentifierBridge<Object>>)this.beanResolver.resolve(this.providedIdentifierBridge));
                this.documentIdSourceProperty = Optional.empty();
            } else if (this.entityIdPropertyPath != null) {
                this.identifierBridge(this.entityIdPropertyPath, null);
            } else {
                throw log.missingIdentifierMapping(this.typeModel);
            }
        }
        if (this.routingKeyProvider == null) {
            this.routingKeyProvider = RoutingKeyProvider.alwaysNull();
        }
    }
}

