/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoXClassOrdering;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.common.impl.StreamHelper;

public abstract class AbstractPojoHCAnnBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private final ReflectionManager reflectionManager;
    private final PojoXClassOrdering typeOrdering;

    public AbstractPojoHCAnnBootstrapIntrospector(ReflectionManager reflectionManager) {
        this.reflectionManager = reflectionManager;
        this.typeOrdering = new PojoXClassOrdering(reflectionManager);
    }

    public Stream<Annotation> annotations(XAnnotatedElement xAnnotated) {
        return Arrays.stream(xAnnotated.getAnnotations());
    }

    public XClass toXClass(Class<?> type) {
        return this.reflectionManager.toXClass(type);
    }

    public Map<String, XProperty> declaredFieldAccessXPropertiesByName(XClass xClass) {
        return xClass.getDeclaredProperties("field").stream().collect(this.xPropertiesByNameNoDuplicate());
    }

    public Map<String, XProperty> declaredMethodAccessXPropertiesByName(XClass xClass) {
        return xClass.getDeclaredProperties("property").stream().collect(this.xPropertiesByNameNoDuplicate());
    }

    public Stream<Class<?>> ascendingSuperClasses(XClass xClass) {
        return this.typeOrdering.ascendingSuperTypes(xClass).map(this::toClass);
    }

    public Stream<Class<?>> descendingSuperClasses(XClass xClass) {
        return this.typeOrdering.descendingSuperTypes(xClass).map(this::toClass);
    }

    private Class<?> toClass(XClass xClass) {
        return this.reflectionManager.toClass(xClass);
    }

    private Collector<XProperty, ?, Map<String, XProperty>> xPropertiesByNameNoDuplicate() {
        return StreamHelper.toMap(XMember::getName, Function.identity(), TreeMap::new);
    }
}

