/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.identifiertovalue.impl.IdentifierBinderToValueBinderAdapter;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIdentityMappingCollector;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexedEmbeddedIdentityMappingCollector<E>
implements PojoIdentityMappingCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeModel<E> typeModel;
    private final PojoMappingHelper mappingHelper;
    private BoundPojoModelPathPropertyNode<?, ?> identifierModelPath;
    private IdentifierBinder identifierBinder;

    PojoIndexedEmbeddedIdentityMappingCollector(PojoRawTypeModel<E> typeModel, PojoMappingHelper mappingHelper) {
        this.typeModel = typeModel;
        this.mappingHelper = mappingHelper;
    }

    @Override
    public <T> void identifierBridge(BoundPojoModelPathPropertyNode<?, T> modelPath, IdentifierBinder binder) {
        this.identifierModelPath = modelPath;
        this.identifierBinder = binder;
    }

    public void contributeIdentifierField(AbstractPojoIndexingProcessorTypeNodeBuilder<?, ?> embeddedTypeNodeBuilder) {
        if (this.identifierModelPath == null) {
            Optional<BoundPojoModelPathPropertyNode<E, ?>> entityIdPropertyPath = this.mappingHelper.indexModelBinder().createEntityIdPropertyPath(this.typeModel);
            if (entityIdPropertyPath.isPresent()) {
                this.identifierBridge(entityIdPropertyPath.get(), null);
            } else {
                throw log.missingIdentifierMapping(this.typeModel);
            }
        }
        embeddedTypeNodeBuilder.property(this.identifierModelPath.getPropertyModel().name()).value(ContainerExtractorPath.defaultExtractors()).valueBinder(this.identifierBinder == null ? null : new IdentifierBinderToValueBinderAdapter(this.identifierBinder), null, context -> context.standardTypeOptionsStep().searchable(Searchable.YES).projectable(Projectable.YES));
    }
}

