/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorTypeBridgeNode<T>
extends PojoIndexingProcessor<T> {
    private final BeanHolder<? extends TypeBridge> bridgeHolder;

    public PojoIndexingProcessorTypeBridgeNode(BeanHolder<? extends TypeBridge> bridgeHolder) {
        this.bridgeHolder = bridgeHolder;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(TypeBridge::close, this.bridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"apply type bridge");
        builder.attribute("bridge", this.bridgeHolder);
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorSessionContext sessionContext) {
        ((TypeBridge)this.bridgeHolder.get()).write(target, source, sessionContext.typeBridgeWriteContext());
    }
}

