/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public abstract class AbstractPojoHCAnnPropertyModel<T, I extends AbstractPojoHCAnnBootstrapIntrospector>
implements PojoPropertyModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final I introspector;
    protected final AbstractPojoHCAnnRawTypeModel<?, I> holderTypeModel;
    protected final String name;
    protected final List<XProperty> declaredXProperties;
    protected final Member member;
    private ValueReadHandle<T> handle;
    private PojoGenericTypeModel<T> typeModel;

    public AbstractPojoHCAnnPropertyModel(I introspector, AbstractPojoHCAnnRawTypeModel<?, I> holderTypeModel, String name, List<XProperty> declaredXProperties, Member member) {
        this.introspector = introspector;
        this.holderTypeModel = holderTypeModel;
        this.name = name;
        this.declaredXProperties = declaredXProperties;
        this.member = member;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final Stream<Annotation> annotations() {
        return this.declaredXProperties.stream().flatMap(arg_0 -> this.introspector.annotations(arg_0));
    }

    @Override
    public final PojoGenericTypeModel<T> typeModel() {
        if (this.typeModel == null) {
            try {
                this.typeModel = this.holderTypeModel.rawTypeDeclaringContext.createGenericTypeModel(this.getterGenericReturnType());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.name(), this.holderTypeModel, e);
            }
        }
        return this.typeModel;
    }

    @Override
    public final ValueReadHandle<T> handle() {
        if (this.handle == null) {
            try {
                this.handle = this.createHandle();
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.name(), this.holderTypeModel, e);
            }
        }
        return this.handle;
    }

    protected abstract ValueReadHandle<T> createHandle() throws ReflectiveOperationException;

    final Type getterGenericReturnType() {
        if (this.member instanceof Method) {
            return ((Method)this.member).getGenericReturnType();
        }
        if (this.member instanceof Field) {
            return ((Field)this.member).getGenericType();
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + this.member + " has type " + (this.member == null ? null : this.member.getClass()));
    }
}

