/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.automaticindexing.spi.PojoImplicitReindexingResolverSessionContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

abstract class AbstractPojoTypeIndexingPlan<I, E, S extends AbstractEntityState> {
    final PojoWorkSessionContext<?> sessionContext;
    final Map<I, S> statesPerId = new LinkedHashMap<I, S>();

    AbstractPojoTypeIndexingPlan(PojoWorkSessionContext<?> sessionContext) {
        this.sessionContext = sessionContext;
    }

    void add(Object providedId, String providedRoutingKey, Object entity) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        ((AbstractEntityState)this.getState(identifier)).add(entitySupplier, providedRoutingKey);
    }

    void update(Object providedId, String providedRoutingKey, Object entity) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        ((AbstractEntityState)this.getState(identifier)).update(entitySupplier, providedRoutingKey);
    }

    void update(Object providedId, String providedRoutingKey, Object entity, String ... dirtyPaths) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        ((AbstractEntityState)this.getState(identifier)).update(entitySupplier, providedRoutingKey, dirtyPaths);
    }

    void delete(Object providedId, String providedRoutingKey, Object entity) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        ((AbstractEntityState)this.getState(identifier)).delete(entitySupplier, providedRoutingKey);
    }

    abstract void purge(Object var1, String var2);

    void resolveDirty(PojoReindexingCollector containingEntityCollector) {
        for (AbstractEntityState state : this.statesPerId.values()) {
            state.resolveDirty(containingEntityCollector);
        }
    }

    abstract PojoWorkTypeContext<E> typeContext();

    abstract I toIdentifier(Object var1, Supplier<E> var2);

    final S getState(I identifier) {
        AbstractEntityState state = (AbstractEntityState)this.statesPerId.get(identifier);
        if (state == null) {
            state = this.createState(identifier);
            this.statesPerId.put(identifier, state);
        }
        return (S)state;
    }

    protected abstract S createState(I var1);

    protected static enum EntityStatus {
        UNKNOWN,
        PRESENT,
        ABSENT;

    }

    abstract class AbstractEntityState
    implements PojoImplicitReindexingResolverRootContext<Set<String>> {
        final I identifier;
        Supplier<E> entitySupplier;
        EntityStatus initialStatus = EntityStatus.UNKNOWN;
        EntityStatus currentStatus = EntityStatus.UNKNOWN;
        boolean shouldResolveToReindex;
        boolean considerAllDirty;
        Set<String> dirtyPaths;

        AbstractEntityState(I identifier) {
            this.identifier = identifier;
        }

        @Override
        public PojoImplicitReindexingResolverSessionContext sessionContext() {
            return AbstractPojoTypeIndexingPlan.this.sessionContext;
        }

        @Override
        public Set<String> dirtinessState() {
            return this.dirtyPaths;
        }

        void add(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.entitySupplier = entitySupplier;
            this.shouldResolveToReindex = true;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.ABSENT;
            }
            this.currentStatus = EntityStatus.PRESENT;
        }

        void update(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.doUpdate(entitySupplier, providedRoutingKey);
            this.shouldResolveToReindex = true;
            this.considerAllDirty = true;
            this.dirtyPaths = null;
        }

        void update(Supplier<E> entitySupplier, String providedRoutingKey, String ... dirtyPaths) {
            this.doUpdate(entitySupplier, providedRoutingKey);
            this.shouldResolveToReindex = true;
            if (!this.considerAllDirty) {
                for (String dirtyPath : dirtyPaths) {
                    this.addDirtyPath(dirtyPath);
                }
            }
        }

        void doUpdate(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.entitySupplier = entitySupplier;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.PRESENT;
            }
            this.currentStatus = EntityStatus.PRESENT;
        }

        void delete(Supplier<E> entitySupplier, String providedRoutingKey) {
            this.entitySupplier = entitySupplier;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.PRESENT;
            }
            this.currentStatus = EntityStatus.ABSENT;
            this.shouldResolveToReindex = false;
            this.considerAllDirty = false;
            this.dirtyPaths = null;
        }

        void resolveDirty(PojoReindexingCollector containingEntityCollector) {
            if (this.shouldResolveToReindex) {
                this.shouldResolveToReindex = false;
                AbstractPojoTypeIndexingPlan.this.typeContext().resolveEntitiesToReindex(containingEntityCollector, AbstractPojoTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier, this);
            }
        }

        private void addDirtyPath(String dirtyPath) {
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new HashSet<String>();
            }
            this.dirtyPaths.add(dirtyPath);
        }
    }
}

