/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.mapper.pojo.extractor.ValueProcessor;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorContainerExtractionContext;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorContainerElementNode<C, V>
extends PojoIndexingProcessor<C> {
    private final ContainerExtractorHolder<C, V> extractorHolder;
    private final PojoIndexingProcessor<? super V> nested;
    private final ValueProcessor<DocumentElement, ? super C, PojoIndexingProcessorSessionContext> extractingDelegate;

    public PojoIndexingProcessorContainerElementNode(ContainerExtractorHolder<C, V> extractorHolder, PojoIndexingProcessor<? super V> nested) {
        this.extractorHolder = extractorHolder;
        this.nested = nested;
        this.extractingDelegate = extractorHolder.wrap((target, value, sessionContext, extractionContext) -> nested.process((DocumentElement)target, (Object)value, (PojoIndexingProcessorSessionContext)sessionContext));
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ContainerExtractorHolder::close, this.extractorHolder);
            closer.push(PojoIndexingProcessor::close, this.nested);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process container element");
        builder.attribute("extractor", this.extractorHolder);
        builder.attribute("nested", this.nested);
    }

    @Override
    public final void process(DocumentElement target, C source, PojoIndexingProcessorSessionContext sessionContext) {
        this.extractingDelegate.process(target, (PojoIndexingProcessorSessionContext)source, sessionContext, PojoIndexingProcessorContainerExtractionContext.INSTANCE);
    }
}

