/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.impl;

import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoImplicitReindexingResolverDirtinessFilterNode<T, S>
extends PojoImplicitReindexingResolverNode<T, S> {
    private final PojoPathFilter<S> dirtyPathFilter;
    private final PojoImplicitReindexingResolverNode<T, S> nested;

    public PojoImplicitReindexingResolverDirtinessFilterNode(PojoPathFilter<S> dirtyPathFilter, PojoImplicitReindexingResolverNode<T, S> nested) {
        Contracts.assertNotNull(dirtyPathFilter, (String)"dirtyPathFilter");
        this.dirtyPathFilter = dirtyPathFilter;
        this.nested = nested;
    }

    @Override
    public void close() {
        this.nested.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"reindex only if paths are dirty");
        builder.attribute("dirtyPathFilter", this.dirtyPathFilter);
        builder.attribute("nested", this.nested);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, T dirty, PojoImplicitReindexingResolverRootContext<S> context) {
        S dirtinessState = context.dirtinessState();
        if (dirtinessState == null || this.dirtyPathFilter.test(dirtinessState)) {
            this.nested.resolveEntitiesToReindex(collector, dirty, context);
        }
    }
}

