/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.route.impl.DocumentRouteImpl;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentReferenceProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkRouter;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoIndexedTypeIndexingPlan<I, E, R>
extends AbstractPojoTypeIndexingPlan<I, E, IndexedEntityState> {
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final IndexIndexingPlan<R> delegate;

    public PojoIndexedTypeIndexingPlan(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext<?> sessionContext, IndexIndexingPlan<R> delegate) {
        super(sessionContext);
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    @Override
    void purge(Object providedId, String providedRoutingKey) {
        I identifier = this.typeContext.identifierMapping().getIdentifier(providedId);
        ((IndexedEntityState)this.getState(identifier)).purge(providedRoutingKey);
    }

    void updateBecauseOfContained(Object entity) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.identifierMapping().getIdentifier(null, entitySupplier);
        ((IndexedEntityState)this.getState(identifier)).updateBecauseOfContained(entitySupplier);
    }

    @Override
    void resolveDirty(PojoReindexingCollector containingEntityCollector) {
        ArrayList frozenIndexingPlansPerId = new ArrayList(this.statesPerId.values());
        for (IndexedEntityState plan : frozenIndexingPlansPerId) {
            plan.resolveDirty(containingEntityCollector);
        }
    }

    void discard() {
        this.delegate.discard();
    }

    void discardNotProcessed() {
        this.statesPerId.clear();
    }

    void process() {
        this.sendCommandsToDelegate();
        this.delegate.process();
    }

    CompletableFuture<IndexIndexingPlanExecutionReport<R>> executeAndReport() {
        this.sendCommandsToDelegate();
        return this.delegate.executeAndReport();
    }

    PojoWorkIndexedTypeContext<I, E> typeContext() {
        return this.typeContext;
    }

    @Override
    I toIdentifier(Object providedId, Supplier<E> entitySupplier) {
        return this.typeContext.identifierMapping().getIdentifier(providedId, entitySupplier);
    }

    @Override
    protected IndexedEntityState createState(I identifier) {
        return new IndexedEntityState(identifier);
    }

    private void sendCommandsToDelegate() {
        try {
            this.statesPerId.values().forEach(IndexedEntityState::sendCommandsToDelegate);
        }
        finally {
            this.statesPerId.clear();
        }
    }

    class IndexedEntityState
    extends AbstractPojoTypeIndexingPlan.AbstractEntityState {
        private String providedRoutingKey;
        private boolean updatedBecauseOfContained;

        private IndexedEntityState(I identifier) {
            super(identifier);
        }

        @Override
        void add(Supplier<E> entitySupplier, String providedRoutingKey) {
            super.add(entitySupplier, providedRoutingKey);
            this.providedRoutingKey = providedRoutingKey;
        }

        @Override
        void doAddOrUpdate(Supplier<E> entitySupplier, String providedRoutingKey) {
            super.doAddOrUpdate(entitySupplier, providedRoutingKey);
            this.providedRoutingKey = providedRoutingKey;
        }

        void updateBecauseOfContained(Supplier<E> entitySupplier) {
            if (this.currentStatus == AbstractPojoTypeIndexingPlan.EntityStatus.ABSENT) {
                return;
            }
            this.doAddOrUpdate(entitySupplier, null);
            this.updatedBecauseOfContained = true;
        }

        @Override
        void delete(Supplier<E> entitySupplier, String providedRoutingKey) {
            super.delete(entitySupplier, providedRoutingKey);
            this.providedRoutingKey = providedRoutingKey;
            this.updatedBecauseOfContained = false;
        }

        void purge(String providedRoutingKey) {
            this.initialStatus = AbstractPojoTypeIndexingPlan.EntityStatus.PRESENT;
            this.delete(null, providedRoutingKey);
        }

        void sendCommandsToDelegate() {
            switch (this.currentStatus) {
                case UNKNOWN: {
                    return;
                }
                case PRESENT: {
                    switch (this.initialStatus) {
                        case ABSENT: {
                            this.delegateAdd();
                            return;
                        }
                        case PRESENT: 
                        case UNKNOWN: {
                            if (this.considerAllDirty || this.updatedBecauseOfContained || PojoIndexedTypeIndexingPlan.this.typeContext.requiresSelfReindexing(this.dirtyPaths)) {
                                this.delegateAddOrUpdate();
                            }
                            return;
                        }
                    }
                    break;
                }
                case ABSENT: {
                    switch (this.initialStatus) {
                        case ABSENT: {
                            return;
                        }
                        case PRESENT: 
                        case UNKNOWN: {
                            this.delegateDelete();
                            return;
                        }
                    }
                }
            }
        }

        private void delegateAdd() {
            PojoWorkRouter router = PojoIndexedTypeIndexingPlan.this.typeContext.createRouter(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier);
            DocumentRouteImpl currentRoute = router.currentRoute(this.providedRoutingKey);
            String documentIdentifier = PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentIdentifier(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier);
            if (currentRoute == null) {
                return;
            }
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), this.identifier);
            PojoIndexedTypeIndexingPlan.this.delegate.add((DocumentReferenceProvider)referenceProvider, PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentContributor(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier));
        }

        private void delegateAddOrUpdate() {
            PojoWorkRouter router = PojoIndexedTypeIndexingPlan.this.typeContext.createRouter(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier);
            DocumentRouteImpl currentRoute = router.currentRoute(this.providedRoutingKey);
            List<DocumentRouteImpl> previousRoutes = router.previousRoutes(currentRoute);
            String documentIdentifier = PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentIdentifier(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier);
            this.delegateDeletePrevious(documentIdentifier, previousRoutes);
            if (currentRoute == null) {
                return;
            }
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), this.identifier);
            PojoIndexedTypeIndexingPlan.this.delegate.addOrUpdate((DocumentReferenceProvider)referenceProvider, PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentContributor(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier));
        }

        private void delegateDelete() {
            String documentIdentifier = PojoIndexedTypeIndexingPlan.this.typeContext.toDocumentIdentifier(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier);
            if (this.entitySupplier == null) {
                PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, this.providedRoutingKey, this.identifier);
                PojoIndexedTypeIndexingPlan.this.delegate.delete((DocumentReferenceProvider)referenceProvider);
                return;
            }
            PojoWorkRouter router = PojoIndexedTypeIndexingPlan.this.typeContext.createRouter(PojoIndexedTypeIndexingPlan.this.sessionContext, this.identifier, this.entitySupplier);
            DocumentRouteImpl currentRoute = router.currentRoute(this.providedRoutingKey);
            List<DocumentRouteImpl> previousRoutes = router.previousRoutes(currentRoute);
            this.delegateDeletePrevious(documentIdentifier, previousRoutes);
            if (currentRoute == null) {
                return;
            }
            PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, currentRoute.routingKey(), this.identifier);
            PojoIndexedTypeIndexingPlan.this.delegate.delete((DocumentReferenceProvider)referenceProvider);
        }

        private void delegateDeletePrevious(String documentIdentifier, List<DocumentRouteImpl> previousRoutes) {
            for (DocumentRouteImpl route : previousRoutes) {
                PojoDocumentReferenceProvider referenceProvider = new PojoDocumentReferenceProvider(documentIdentifier, route.routingKey(), this.identifier);
                PojoIndexedTypeIndexingPlan.this.delegate.delete((DocumentReferenceProvider)referenceProvider);
            }
        }
    }
}

