/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.Instant;
import java.util.Date;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaUtilDateValueBridge
implements ValueBridge<Date, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Instant toIndexedValue(Date value, ValueBridgeToIndexedValueContext context) {
        return DefaultJavaUtilDateValueBridge.to(value);
    }

    @Override
    public Date fromIndexedValue(Instant value, ValueBridgeFromIndexedValueContext context) {
        return DefaultJavaUtilDateValueBridge.from(value);
    }

    @Override
    public Instant parse(String value) {
        return ParseUtils.parseInstant((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    static Instant to(Date value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochMilli(value.getTime());
    }

    static Date from(Instant value) {
        return value == null ? null : Date.from(value);
    }
}

