/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeFromDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;

public final class DefaultMonthDayIdentifierBridge
implements IdentifierBridge<MonthDay> {
    private static final DateTimeFormatter FORMATTER = ParseUtils.ISO_MONTH_DAY;

    @Override
    public String toDocumentIdentifier(MonthDay propertyValue, IdentifierBridgeToDocumentIdentifierContext context) {
        return FORMATTER.format(propertyValue);
    }

    @Override
    public MonthDay fromDocumentIdentifier(String documentIdentifier, IdentifierBridgeFromDocumentIdentifierContext context) {
        return ParseUtils.parseMonthDay((String)documentIdentifier);
    }

    @Override
    public boolean isCompatibleWith(IdentifierBridge<?> other) {
        return this.getClass().equals(other.getClass());
    }
}

