/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverContainerElementNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverPropertyNode;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathFilterProvider;
import org.hibernate.search.util.common.impl.Closer;

class PojoImplicitReindexingResolverPropertyNodeBuilder<T, P>
extends AbstractPojoImplicitReindexingResolverNodeBuilder<T> {
    private final BoundPojoModelPathPropertyNode<T, P> modelPath;
    private final PojoImplicitReindexingResolverValueNodeBuilderDelegate<P> valueWithoutExtractorsBuilderDelegate;
    private final Map<ContainerExtractorPath, PojoImplicitReindexingResolverContainerElementNodeBuilder<? super P, ?>> containerElementNodeBuilders = new LinkedHashMap();

    PojoImplicitReindexingResolverPropertyNodeBuilder(BoundPojoModelPathPropertyNode<T, P> modelPath, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.modelPath = modelPath;
        BoundContainerExtractorPath<P, P> noExtractorsBoundPath = BoundContainerExtractorPath.noExtractors(modelPath.getPropertyModel().typeModel());
        this.valueWithoutExtractorsBuilderDelegate = new PojoImplicitReindexingResolverValueNodeBuilderDelegate<P>(modelPath.value(noExtractorsBoundPath), buildingHelper);
    }

    @Override
    BoundPojoModelPathPropertyNode<T, P> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(PojoImplicitReindexingResolverValueNodeBuilderDelegate::closeOnFailure, this.valueWithoutExtractorsBuilderDelegate);
            closer.pushAll(AbstractPojoImplicitReindexingResolverNodeBuilder::closeOnFailure, this.containerElementNodeBuilders.values());
        }
    }

    PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> value(ContainerExtractorPath extractorPath) {
        if (!extractorPath.isEmpty()) {
            PojoImplicitReindexingResolverContainerElementNodeBuilder<P, ?> containerElementNodeBuilder = this.containerElementNodeBuilders.get(extractorPath);
            if (containerElementNodeBuilder == null && !this.containerElementNodeBuilders.containsKey(extractorPath)) {
                this.checkNotFrozen();
                BoundContainerExtractorPath<P, ?> boundExtractorPath = this.buildingHelper.extractorBinder().bindPath(this.modelPath.getPropertyModel().typeModel(), extractorPath);
                ContainerExtractorPath explicitExtractorPath = boundExtractorPath.getExtractorPath();
                if (!explicitExtractorPath.isEmpty() && (containerElementNodeBuilder = this.containerElementNodeBuilders.get(explicitExtractorPath)) == null) {
                    containerElementNodeBuilder = this.createContainerBuilder(boundExtractorPath);
                }
                this.containerElementNodeBuilders.put(explicitExtractorPath, containerElementNodeBuilder);
                this.containerElementNodeBuilders.put(extractorPath, containerElementNodeBuilder);
            }
            if (containerElementNodeBuilder != null) {
                return containerElementNodeBuilder.value();
            }
        }
        return this.valueWithoutExtractorsBuilderDelegate;
    }

    @Override
    protected void onFreeze(Set<PojoModelPathValueNode> dirtyPathsTriggeringReindexingCollector) {
        this.valueWithoutExtractorsBuilderDelegate.freeze(dirtyPathsTriggeringReindexingCollector);
        for (PojoImplicitReindexingResolverContainerElementNodeBuilder<P, ?> builder : this.containerElementNodeBuilders.values()) {
            if (builder == null) continue;
            builder.freeze();
            dirtyPathsTriggeringReindexingCollector.addAll(builder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
        }
    }

    @Override
    Optional<PojoImplicitReindexingResolverNode<T>> doBuild(PojoPathFilterProvider pathFilterProvider, Set<PojoModelPathValueNode> allPotentialDirtyPaths) {
        this.checkFrozen();
        Collection<PojoImplicitReindexingResolverNode<P>> valueWithoutExtractorTypeNodes = this.valueWithoutExtractorsBuilderDelegate.buildTypeNodes(pathFilterProvider, allPotentialDirtyPaths);
        ArrayList<PojoImplicitReindexingResolverNode<P>> immutableNestedNodes = new ArrayList<PojoImplicitReindexingResolverNode<P>>();
        immutableNestedNodes.addAll(valueWithoutExtractorTypeNodes);
        this.containerElementNodeBuilders.values().stream().distinct().filter(Objects::nonNull).map(builder -> builder.build(pathFilterProvider, allPotentialDirtyPaths)).filter(Optional::isPresent).map(Optional::get).forEach(immutableNestedNodes::add);
        if (immutableNestedNodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PojoImplicitReindexingResolverPropertyNode(this.modelPath.getPropertyModel().handle(), this.createNested(immutableNestedNodes)));
    }

    private <V> PojoImplicitReindexingResolverContainerElementNodeBuilder<? super P, V> createContainerBuilder(BoundContainerExtractorPath<P, V> boundExtractorPath) {
        ContainerExtractorHolder<P, V> extractorHolder = this.buildingHelper.createExtractors(boundExtractorPath);
        BoundPojoModelPathValueNode<T, P, V> containerElementPath = this.modelPath.value(boundExtractorPath);
        return new PojoImplicitReindexingResolverContainerElementNodeBuilder<P, V>(containerElementPath, extractorHolder, this.buildingHelper);
    }
}

