/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.identity.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeMappingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public final class PropertyIdentifierMapping<I, E>
implements IdentifierMappingImplementor<I, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoCaster<? super I> caster;
    private final ValueReadHandle<I> property;
    private final BeanHolder<? extends IdentifierBridge<I>> bridgeHolder;

    public PropertyIdentifierMapping(PojoCaster<? super I> caster, ValueReadHandle<I> property, BeanHolder<? extends IdentifierBridge<I>> bridgeHolder) {
        this.caster = caster;
        this.property = property;
        this.bridgeHolder = bridgeHolder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[handle=" + this.property + ", bridgeHolder=" + this.bridgeHolder + "]";
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierBridge::close, this.bridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    @Override
    public I getIdentifier(Object providedId, Supplier<? extends E> entitySupplierOrNull) {
        if (providedId != null) {
            return this.caster.cast(providedId);
        }
        if (entitySupplierOrNull == null) {
            throw log.nullProvidedIdentifierAndEntity();
        }
        return (I)this.property.get(entitySupplierOrNull.get());
    }

    @Override
    public String toDocumentIdentifier(I identifier, BridgeMappingContext context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).toDocumentIdentifier(identifier, context.identifierBridgeToDocumentIdentifierContext());
    }

    @Override
    public I fromDocumentIdentifier(String documentId, BridgeSessionContext context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).fromDocumentIdentifier(documentId, context.identifierBridgeFromDocumentIdentifierContext());
    }
}

