/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.identity.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeMappingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ProvidedIdentifierMapping
implements IdentifierMappingImplementor<Object, Object> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanHolder<? extends IdentifierBridge<Object>> bridgeHolder;

    public static <E> IdentifierMappingImplementor<Object, E> get(BeanHolder<? extends IdentifierBridge<Object>> bridgeHolder) {
        return new ProvidedIdentifierMapping(bridgeHolder);
    }

    private ProvidedIdentifierMapping(BeanHolder<? extends IdentifierBridge<Object>> bridgeHolder) {
        this.bridgeHolder = bridgeHolder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bridgeHolder=" + this.bridgeHolder + "]";
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierBridge::close, this.bridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    @Override
    public Object getIdentifier(Object providedId, Supplier<?> entityProvider) {
        if (providedId == null) {
            throw log.nullProvidedIdentifier();
        }
        return providedId;
    }

    @Override
    public String toDocumentIdentifier(Object identifier, BridgeMappingContext context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).toDocumentIdentifier(identifier, context.identifierBridgeToDocumentIdentifierContext());
    }

    @Override
    public Object fromDocumentIdentifier(String documentId, BridgeSessionContext context) {
        return ((IdentifierBridge)this.bridgeHolder.get()).fromDocumentIdentifier(documentId, context.identifierBridgeFromDocumentIdentifierContext());
    }
}

