/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgesConfigurationContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BridgeResolver;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorConfigurationContext;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.spi.ContainerExtractorRegistry;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingMode;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMapper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationMappingConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.ProgrammaticMappingConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoMappingConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;

public abstract class AbstractPojoMappingInitiator<MPBS extends MappingPartialBuildState>
implements MappingInitiator<PojoTypeMetadataContributor, MPBS> {
    private final PojoBootstrapIntrospector introspector;
    private BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge;
    private IdentityMappingMode containedEntityIdentityMappingMode = IdentityMappingMode.OPTIONAL;
    private TenancyMode tenancyMode = TenancyMode.SINGLE_TENANCY;
    private ReindexOnUpdate defaultReindexOnUpdate = ReindexOnUpdate.DEFAULT;
    private final AnnotationMappingConfigurationContextImpl annotationMappingConfiguration;
    private final TypePatternMatcherFactory typePatternMatcherFactory;
    private final ContainerExtractorRegistry.Builder containerExtractorRegistryBuilder;
    private final BridgeResolver.Builder bridgeResolverBuilder;
    private final List<PojoMappingConfigurationContributor> delegates = new ArrayList<PojoMappingConfigurationContributor>();
    private ContainerExtractorBinder extractorBinder;
    private BridgeResolver bridgeResolver;

    protected AbstractPojoMappingInitiator(PojoBootstrapIntrospector introspector) {
        this.introspector = introspector;
        this.annotationMappingConfiguration = new AnnotationMappingConfigurationContextImpl(introspector);
        this.addConfigurationContributor(this.annotationMappingConfiguration);
        this.typePatternMatcherFactory = new TypePatternMatcherFactory(introspector);
        this.containerExtractorRegistryBuilder = ContainerExtractorRegistry.builder();
        this.bridgeResolverBuilder = new BridgeResolver.Builder(introspector, this.typePatternMatcherFactory);
    }

    public ProgrammaticMappingConfigurationContext programmaticMapping() {
        ProgrammaticMappingConfigurationContextImpl context = new ProgrammaticMappingConfigurationContextImpl(this.introspector);
        this.addConfigurationContributor(context);
        return context;
    }

    public AnnotationMappingConfigurationContext annotationMapping() {
        return this.annotationMappingConfiguration;
    }

    public ContainerExtractorConfigurationContext containerExtractors() {
        return this.containerExtractorRegistryBuilder;
    }

    public BridgesConfigurationContext bridges() {
        return this.bridgeResolverBuilder;
    }

    public void providedIdentifierBridge(BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge) {
        this.providedIdentifierBridge = providedIdentifierBridge;
    }

    public void containedEntityIdentityMappingRequired(boolean required) {
        this.containedEntityIdentityMappingMode = required ? IdentityMappingMode.REQUIRED : IdentityMappingMode.OPTIONAL;
    }

    public void multiTenancyEnabled(boolean multiTenancyEnabled) {
        this.tenancyMode = multiTenancyEnabled ? TenancyMode.MULTI_TENANCY : TenancyMode.SINGLE_TENANCY;
    }

    public void defaultReindexOnUpdate(ReindexOnUpdate defaultReindexOnUpdate) {
        this.defaultReindexOnUpdate = defaultReindexOnUpdate;
    }

    public void annotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.annotationMappingConfiguration.setAnnotatedTypeDiscoveryEnabled(annotatedTypeDiscoveryEnabled);
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        ContainerExtractorRegistry containerExtractorRegistry = this.containerExtractorRegistryBuilder.build();
        this.extractorBinder = new ContainerExtractorBinder(buildContext.beanResolver(), containerExtractorRegistry, this.typePatternMatcherFactory);
        this.bridgeResolver = this.bridgeResolverBuilder.build();
        PojoMappingConfigurationContextImpl configurationContext = new PojoMappingConfigurationContextImpl(this.extractorBinder);
        for (PojoMappingConfigurationContributor delegate : this.delegates) {
            delegate.configure(buildContext, configurationContext, configurationCollector);
        }
    }

    public Mapper<MPBS> createMapper(MappingBuildContext buildContext, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider) {
        return new PojoMapper<MPBS>(buildContext, contributorProvider, this.introspector, this.extractorBinder, this.bridgeResolver, this.providedIdentifierBridge, this.containedEntityIdentityMappingMode, this.tenancyMode, this.defaultReindexOnUpdate, this.createMapperDelegate());
    }

    protected abstract PojoMapperDelegate<MPBS> createMapperDelegate();

    protected final void addConfigurationContributor(PojoMappingConfigurationContributor contributor) {
        this.delegates.add(contributor);
    }
}

