/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.util.Objects;
import org.hibernate.search.util.common.impl.Contracts;

public final class PojoRawTypeIdentifier<T> {
    private final Class<T> javaClass;
    private final String name;

    public static <T> PojoRawTypeIdentifier<T> of(Class<T> javaClass) {
        return new PojoRawTypeIdentifier<T>(javaClass, null);
    }

    public static <T> PojoRawTypeIdentifier<T> of(Class<T> javaClass, String label) {
        return new PojoRawTypeIdentifier<T>(javaClass, label);
    }

    private PojoRawTypeIdentifier(Class<T> javaClass, String name) {
        Contracts.assertNotNull(javaClass, (String)"javaClass");
        this.javaClass = javaClass;
        this.name = name;
    }

    public String toString() {
        if (this.name == null) {
            return this.javaClass.getName();
        }
        return this.name + " (" + this.javaClass.getName() + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PojoRawTypeIdentifier)) {
            return false;
        }
        PojoRawTypeIdentifier other = (PojoRawTypeIdentifier)obj;
        return this.javaClass.equals(other.javaClass) && Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass, this.name);
    }

    public Class<T> javaClass() {
        return this.javaClass;
    }

    public boolean isNamed() {
        return this.name != null;
    }
}

