/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.route;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.util.common.impl.Contracts;

public final class DocumentRoutesDescriptor
implements Serializable {
    private final DocumentRouteDescriptor currentRoute;
    private final Collection<DocumentRouteDescriptor> previousRoutes;

    public static DocumentRoutesDescriptor of(DocumentRouteDescriptor currentRoute) {
        return DocumentRoutesDescriptor.of(currentRoute, Collections.emptySet());
    }

    public static DocumentRoutesDescriptor of(DocumentRouteDescriptor currentRoute, Collection<DocumentRouteDescriptor> previousRoutes) {
        return new DocumentRoutesDescriptor(currentRoute, previousRoutes);
    }

    public static DocumentRoutesDescriptor fromLegacyRoutingKey(String providedRoutingKey) {
        if (providedRoutingKey == null) {
            return null;
        }
        return DocumentRoutesDescriptor.of(DocumentRouteDescriptor.of(providedRoutingKey));
    }

    public DocumentRoutesDescriptor(DocumentRouteDescriptor currentRoute, Collection<DocumentRouteDescriptor> previousRoutes) {
        this.currentRoute = currentRoute;
        Contracts.assertNotNull(previousRoutes, (String)"previousRoutes");
        this.previousRoutes = previousRoutes;
    }

    public String toString() {
        return "DocumentRoutesDescriptor{currentRoute=" + this.currentRoute + ", previousRoutes=" + this.previousRoutes + '}';
    }

    public DocumentRouteDescriptor currentRoute() {
        return this.currentRoute;
    }

    public Collection<DocumentRouteDescriptor> previousRoutes() {
        return this.previousRoutes;
    }
}

