/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.automaticindexing.spi.PojoImplicitReindexingResolverSessionContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.DocumentRouter;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.NoOpDocumentRouter;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.SearchException;

abstract class AbstractPojoTypeIndexingPlan<I, E, S extends AbstractEntityState> {
    final PojoWorkSessionContext sessionContext;
    final PojoTypeIndexingPlanDelegate<I, E> delegate;
    final Map<I, S> statesPerId = new LinkedHashMap<I, S>();

    AbstractPojoTypeIndexingPlan(PojoWorkSessionContext sessionContext, PojoTypeIndexingPlanDelegate<I, E> delegate) {
        this.sessionContext = sessionContext;
        this.delegate = delegate;
    }

    void add(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).add(entitySupplier);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    void addOrUpdate(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).addOrUpdate(entitySupplier, dirtyPaths, forceSelfDirty, forceContainingDirty);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    void delete(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        Supplier<E> entitySupplier = this.typeContext().toEntitySupplier(this.sessionContext, entity);
        I identifier = this.toIdentifier(providedId, entitySupplier);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).delete(entitySupplier);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    void addOrUpdateOrDelete(Object providedId, DocumentRoutesDescriptor providedRoutes, BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
        I identifier = this.toIdentifier(providedId, null);
        S state = this.getState(identifier);
        ((AbstractEntityState)state).addOrUpdateOrDelete(dirtyPaths, forceSelfDirty, forceContainingDirty);
        ((AbstractEntityState)state).providedRoutes(providedRoutes);
    }

    void planLoading(PojoLoadingPlanProvider loadingPlanProvider) {
        for (AbstractEntityState state : this.statesPerId.values()) {
            state.planLoading(loadingPlanProvider);
        }
    }

    void resolveDirty(PojoLoadingPlanProvider loadingPlanProvider, PojoReindexingCollector collector, boolean deleteOnly) {
        for (AbstractEntityState state : this.statesPerId.values()) {
            state.resolveDirty(loadingPlanProvider, collector, deleteOnly);
        }
    }

    void discard() {
        this.delegate.discard();
    }

    void discardNotProcessed() {
        this.statesPerId.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(PojoLoadingPlanProvider loadingPlanProvider) {
        try {
            if (this.delegate == null) {
                return;
            }
            for (AbstractEntityState state : this.statesPerId.values()) {
                state.sendCommandsToDelegate(loadingPlanProvider);
            }
        }
        finally {
            this.statesPerId.clear();
        }
    }

    <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory) {
        return this.delegate.executeAndReport(entityReferenceFactory);
    }

    abstract PojoWorkTypeContext<I, E> typeContext();

    abstract DocumentRouter<? super E> router();

    I toIdentifier(Object providedId, Supplier<E> entitySupplier) {
        return this.typeContext().identifierMapping().getIdentifier(providedId, entitySupplier);
    }

    final S getState(I identifier) {
        AbstractEntityState state = (AbstractEntityState)this.statesPerId.get(identifier);
        if (state == null) {
            state = this.createState(identifier);
            this.statesPerId.put(identifier, state);
        }
        return (S)state;
    }

    protected abstract S createState(I var1);

    protected static enum EntityStatus {
        UNKNOWN,
        PRESENT,
        ABSENT;

    }

    abstract class AbstractEntityState
    implements PojoImplicitReindexingResolverRootContext {
        final I identifier;
        private Supplier<E> entitySupplier;
        private Integer loadingOrdinal;
        EntityStatus initialStatus = EntityStatus.UNKNOWN;
        EntityStatus currentStatus = EntityStatus.UNKNOWN;
        private boolean updatedBecauseOfContained;
        private boolean forceSelfDirty;
        private boolean forceContainingDirty;
        private BitSet dirtyPaths;

        AbstractEntityState(I identifier) {
            this.identifier = identifier;
        }

        @Override
        public PojoImplicitReindexingResolverSessionContext sessionContext() {
            return AbstractPojoTypeIndexingPlan.this.sessionContext;
        }

        public boolean isDirtyForAddOrUpdate() {
            return AbstractPojoTypeIndexingPlan.this.delegate.isDirtyForAddOrUpdate(this.forceSelfDirty, this.forceContainingDirty, this.dirtyPaths);
        }

        @Override
        public boolean isDirtyForReindexingResolution(PojoPathFilter filter) {
            return this.forceContainingDirty || this.dirtyPaths != null && filter.test(this.dirtyPaths);
        }

        @Override
        public void propagateOrIgnoreContainerExtractionException(RuntimeException exception) {
            if (this.isIgnorableDataAccessThrowable(exception)) {
                return;
            }
            throw exception;
        }

        @Override
        public void propagateOrIgnorePropertyAccessException(RuntimeException exception) {
            if (this.isIgnorableDataAccessThrowable(exception)) {
                return;
            }
            throw exception;
        }

        private boolean isIgnorableDataAccessThrowable(RuntimeException exception) {
            Throwable firstNonSearchThrowable = exception;
            while (firstNonSearchThrowable instanceof SearchException) {
                firstNonSearchThrowable = exception.getCause();
            }
            return firstNonSearchThrowable != null && AbstractPojoTypeIndexingPlan.this.sessionContext.runtimeIntrospector().isIgnorableDataAccessThrowable(firstNonSearchThrowable);
        }

        void add(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.ABSENT;
            }
            this.currentStatus = EntityStatus.PRESENT;
            this.forceSelfDirty = true;
            this.forceContainingDirty = true;
            this.dirtyPaths = null;
        }

        void addOrUpdate(Supplier<E> entitySupplier, BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
            this.doAddOrUpdate(entitySupplier);
            this.doUpdateDirty(dirtyPaths, forceSelfDirty, forceContainingDirty);
        }

        void updateBecauseOfContained(Supplier<E> entitySupplier) {
            if (this.currentStatus == EntityStatus.ABSENT) {
                return;
            }
            this.doAddOrUpdate(entitySupplier);
            this.updatedBecauseOfContained = true;
        }

        void doAddOrUpdate(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.PRESENT;
            }
            this.currentStatus = EntityStatus.PRESENT;
        }

        void delete(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (EntityStatus.UNKNOWN.equals((Object)this.initialStatus)) {
                this.initialStatus = EntityStatus.PRESENT;
            }
            this.currentStatus = EntityStatus.ABSENT;
            this.updatedBecauseOfContained = false;
            this.forceSelfDirty = false;
            this.forceContainingDirty = true;
            this.dirtyPaths = null;
        }

        void addOrUpdateOrDelete(BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
            this.entitySupplier = null;
            this.currentStatus = EntityStatus.UNKNOWN;
            this.doUpdateDirty(dirtyPaths, forceSelfDirty, forceContainingDirty);
        }

        protected void doUpdateDirty(BitSet dirtyPaths, boolean forceSelfDirty, boolean forceContainingDirty) {
            this.forceSelfDirty = this.forceSelfDirty || forceSelfDirty;
            boolean bl = this.forceContainingDirty = this.forceContainingDirty || forceContainingDirty;
            if (this.forceSelfDirty && this.forceContainingDirty) {
                this.dirtyPaths = null;
            } else {
                this.addDirtyPaths(dirtyPaths);
            }
        }

        abstract void providedRoutes(DocumentRoutesDescriptor var1);

        abstract DocumentRoutesDescriptor providedRoutes();

        void planLoading(PojoLoadingPlanProvider loadingPlanProvider) {
            if (EntityStatus.ABSENT != this.currentStatus && this.entitySupplier == null) {
                this.loadingOrdinal = loadingPlanProvider.loadingPlan().planLoading(AbstractPojoTypeIndexingPlan.this.typeContext(), this.identifier);
            }
        }

        void resolveDirty(PojoLoadingPlanProvider loadingPlanProvider, PojoReindexingCollector collector, boolean deleteOnly) {
            if (deleteOnly && (this.initialStatus != EntityStatus.PRESENT || this.currentStatus != EntityStatus.ABSENT)) {
                return;
            }
            Supplier entitySupplier = this.entitySupplierOrLoad(loadingPlanProvider);
            if (entitySupplier == null) {
                return;
            }
            AbstractPojoTypeIndexingPlan.this.typeContext().resolveEntitiesToReindex(collector, AbstractPojoTypeIndexingPlan.this.sessionContext, this.identifier, entitySupplier, this);
        }

        void sendCommandsToDelegate(PojoLoadingPlanProvider loadingPlanProvider) {
            if (EntityStatus.UNKNOWN.equals((Object)this.currentStatus)) {
                Supplier entitySupplier = this.entitySupplierOrLoad(loadingPlanProvider);
                this.currentStatus = entitySupplier != null ? EntityStatus.PRESENT : EntityStatus.ABSENT;
            }
            switch (this.currentStatus) {
                case PRESENT: {
                    switch (this.initialStatus) {
                        case ABSENT: {
                            this.delegateAdd(loadingPlanProvider);
                            return;
                        }
                        case PRESENT: 
                        case UNKNOWN: {
                            this.delegateAddOrUpdate(loadingPlanProvider);
                            return;
                        }
                    }
                    break;
                }
                case ABSENT: {
                    switch (this.initialStatus) {
                        case ABSENT: {
                            return;
                        }
                        case PRESENT: 
                        case UNKNOWN: {
                            this.delegateDelete();
                            return;
                        }
                    }
                }
            }
        }

        void delegateAdd(PojoLoadingPlanProvider loadingPlanProvider) {
            Supplier entitySupplier = this.entitySupplierOrLoad(loadingPlanProvider);
            if (entitySupplier == null) {
                return;
            }
            DocumentRouteDescriptor currentRoute = AbstractPojoTypeIndexingPlan.this.router().currentRoute(this.identifier, entitySupplier, this.providedRoutes(), AbstractPojoTypeIndexingPlan.this.sessionContext);
            if (currentRoute == null) {
                return;
            }
            AbstractPojoTypeIndexingPlan.this.delegate.add(this.identifier, currentRoute, entitySupplier);
        }

        void delegateAddOrUpdate(PojoLoadingPlanProvider loadingPlanProvider) {
            boolean updateBecauseOfDirty = this.isDirtyForAddOrUpdate();
            if (!this.updatedBecauseOfContained && !updateBecauseOfDirty) {
                return;
            }
            Supplier entitySupplier = this.entitySupplierOrLoad(loadingPlanProvider);
            if (entitySupplier == null) {
                return;
            }
            DocumentRoutesDescriptor routes = AbstractPojoTypeIndexingPlan.this.router().routes(this.identifier, entitySupplier, this.providedRoutes(), AbstractPojoTypeIndexingPlan.this.sessionContext);
            if (routes.currentRoute() == null && routes.previousRoutes().isEmpty()) {
                return;
            }
            AbstractPojoTypeIndexingPlan.this.delegate.addOrUpdate(this.identifier, routes, entitySupplier, this.forceSelfDirty, this.forceContainingDirty, this.dirtyPaths, this.updatedBecauseOfContained, updateBecauseOfDirty);
        }

        void delegateDelete() {
            Supplier entitySupplier = this.entitySupplierNoLoad();
            DocumentRouter<Object> router = entitySupplier != null ? AbstractPojoTypeIndexingPlan.this.router() : NoOpDocumentRouter.INSTANCE;
            DocumentRoutesDescriptor routes = router.routes(this.identifier, entitySupplier, this.providedRoutes(), AbstractPojoTypeIndexingPlan.this.sessionContext);
            if (routes.currentRoute() == null && routes.previousRoutes().isEmpty()) {
                return;
            }
            AbstractPojoTypeIndexingPlan.this.delegate.delete(this.identifier, routes, entitySupplier);
        }

        Supplier<E> entitySupplierNoLoad() {
            return this.entitySupplier;
        }

        Supplier<E> entitySupplierOrLoad(PojoLoadingPlanProvider loadingPlanProvider) {
            if (this.entitySupplier == null && this.loadingOrdinal != null) {
                Object loaded = loadingPlanProvider.loadingPlan().retrieve(AbstractPojoTypeIndexingPlan.this.typeContext(), this.loadingOrdinal);
                this.entitySupplier = AbstractPojoTypeIndexingPlan.this.typeContext().toEntitySupplier(AbstractPojoTypeIndexingPlan.this.sessionContext, loaded);
                this.loadingOrdinal = null;
            }
            return this.entitySupplier;
        }

        private void addDirtyPaths(BitSet newDirtyPaths) {
            if (newDirtyPaths == null) {
                return;
            }
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new BitSet();
            }
            this.dirtyPaths.or(newDirtyPaths);
        }
    }
}

