/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.impl.PojoMultiLoaderLoadingPlan;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingPlanImpl
implements PojoIndexingPlan,
PojoLoadingPlanProvider,
PojoReindexingCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkIndexedTypeContextProvider indexedTypeContextProvider;
    private final PojoWorkContainedTypeContextProvider containedTypeContextProvider;
    private final PojoWorkSessionContext sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final PojoIndexingPlanStrategy strategy;
    protected final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeIndexingPlan<?, ?>> indexedTypeDelegates = new LinkedHashMap();
    protected final Map<PojoRawTypeIdentifier<?>, PojoContainedTypeIndexingPlan<?, ?>> containedTypeDelegates = new LinkedHashMap();
    private boolean isProcessing = false;
    private boolean mayRequireLoading = false;
    private PojoLoadingPlan<Object> loadingPlan = null;

    public PojoIndexingPlanImpl(PojoWorkIndexedTypeContextProvider indexedTypeContextProvider, PojoWorkContainedTypeContextProvider containedTypeContextProvider, PojoWorkSessionContext sessionContext, PojoIndexingPlanStrategy strategy) {
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.containedTypeContextProvider = containedTypeContextProvider;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.runtimeIntrospector();
        this.strategy = strategy;
    }

    @Override
    public void add(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        if (!this.mayRequireLoading && entity == null) {
            this.mayRequireLoading = true;
        }
        delegate.add(providedId, providedRoutes, entity);
    }

    @Override
    public void addOrUpdate(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        if (!this.mayRequireLoading && entity == null) {
            this.mayRequireLoading = true;
        }
        delegate.addOrUpdate(providedId, providedRoutes, entity, dirtyPaths, forceSelfDirty, forceContainingDirty);
    }

    @Override
    public void delete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        delegate.delete(providedId, providedRoutes, entity);
    }

    @Override
    public void addOrUpdateOrDelete(PojoRawTypeIdentifier<?> typeIdentifier, Object providedId, DocumentRoutesDescriptor providedRoutes, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = this.getDelegate(typeIdentifier);
        if (!this.mayRequireLoading) {
            this.mayRequireLoading = true;
        }
        delegate.addOrUpdateOrDelete(providedId, providedRoutes, dirtyPaths, forceSelfDirty, forceContainingDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.isProcessing) {
            throw log.recursiveIndexingPlanProcess();
        }
        this.isProcessing = true;
        try {
            if (this.mayRequireLoading) {
                for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                    pojoContainedTypeIndexingPlan.planLoading(this);
                }
                for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                    pojoIndexedTypeIndexingPlan.planLoading(this);
                }
            }
            if (this.loadingPlan != null) {
                this.loadingPlan.loadBlocking(null);
            }
            boolean shouldResolveDirtyForDeleteOnly = this.strategy.shouldResolveDirtyForDeleteOnly();
            for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.resolveDirty(this, this, shouldResolveDirtyForDeleteOnly);
            }
            ArrayList arrayList = new ArrayList(this.indexedTypeDelegates.values());
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : arrayList) {
                pojoIndexedTypeIndexingPlan.resolveDirty(this, this, shouldResolveDirtyForDeleteOnly);
            }
            for (PojoContainedTypeIndexingPlan<?, ?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.process(this);
            }
            for (PojoIndexedTypeIndexingPlan<?, ?> pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                pojoIndexedTypeIndexingPlan.process(this);
            }
        }
        finally {
            this.isProcessing = false;
            this.mayRequireLoading = false;
            this.loadingPlan = null;
        }
    }

    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory) {
        try {
            this.process();
            CompletableFuture<MultiEntityOperationExecutionReport<R>> completableFuture = this.strategy.doExecuteAndReport(this.indexedTypeDelegates.values(), this, entityReferenceFactory);
            return completableFuture;
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discard() {
        try {
            this.strategy.doDiscard(this.indexedTypeDelegates.values());
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discardNotProcessed() {
        for (PojoIndexedTypeIndexingPlan<?, ?> delegate : this.indexedTypeDelegates.values()) {
            delegate.discardNotProcessed();
        }
    }

    @Override
    public void markForReindexing(Object containingEntity) {
        PojoRawTypeIdentifier<Object> typeIdentifier = this.getIntrospector().detectEntityType(containingEntity);
        if (typeIdentifier == null) {
            throw new AssertionFailure("Attempt to reindex entity " + containingEntity + " because a contained entity was modified, but this entity type is not indexed directly.");
        }
        PojoIndexedTypeIndexingPlan<?, ?> delegate = this.getOrCreateIndexedDelegateForContainedUpdate(typeIdentifier);
        delegate.updateBecauseOfContained(containingEntity);
    }

    private PojoRuntimeIntrospector getIntrospector() {
        return this.introspector;
    }

    private AbstractPojoTypeIndexingPlan<?, ?, ?> getDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        AbstractPojoTypeIndexingPlan<?, ?, ?> delegate = (AbstractPojoTypeIndexingPlan<?, ?, ?>)this.indexedTypeDelegates.get(typeIdentifier);
        if (delegate == null && (delegate = (AbstractPojoTypeIndexingPlan)this.containedTypeDelegates.get(typeIdentifier)) == null) {
            delegate = this.createDelegate(typeIdentifier);
        }
        return delegate;
    }

    private AbstractPojoTypeIndexingPlan<?, ?, ?> createDelegate(PojoRawTypeIdentifier<?> typeIdentifier) {
        Optional<PojoWorkIndexedTypeContext<?, ?>> indexedTypeContextOptional = this.indexedTypeContextProvider.forExactType(typeIdentifier);
        if (indexedTypeContextOptional.isPresent()) {
            PojoWorkIndexedTypeContext<?, ?> typeContext = indexedTypeContextOptional.get();
            PojoIndexedTypeIndexingPlan<?, ?> delegate = this.createDelegate(typeContext);
            this.indexedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        Optional<PojoWorkContainedTypeContext<?, ?>> containedTypeContextOptional = this.containedTypeContextProvider.forExactType(typeIdentifier);
        if (containedTypeContextOptional.isPresent()) {
            PojoContainedTypeIndexingPlan<?, ?> delegate = this.createDelegate(containedTypeContextOptional.get());
            this.containedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        throw log.nonIndexedNorContainedTypeInIndexingPlan(typeIdentifier);
    }

    private PojoIndexedTypeIndexingPlan<?, ?> getOrCreateIndexedDelegateForContainedUpdate(PojoRawTypeIdentifier<?> typeIdentifier) {
        PojoIndexedTypeIndexingPlan<?, ?> delegate = this.indexedTypeDelegates.get(typeIdentifier);
        if (delegate != null) {
            return delegate;
        }
        Optional<PojoWorkIndexedTypeContext<?, ?>> indexedTypeContextOptional = this.indexedTypeContextProvider.forExactType(typeIdentifier);
        if (indexedTypeContextOptional.isPresent()) {
            PojoWorkIndexedTypeContext<?, ?> typeContext = indexedTypeContextOptional.get();
            delegate = this.createDelegate(typeContext);
            this.indexedTypeDelegates.put(typeIdentifier, delegate);
            return delegate;
        }
        throw new AssertionFailure("Attempt to reindex an entity of type " + typeIdentifier + " because a contained entity was modified, but this entity type is not indexed directly.");
    }

    @Override
    public PojoLoadingPlan<Object> loadingPlan() {
        if (this.loadingPlan == null) {
            this.loadingPlan = new PojoMultiLoaderLoadingPlan<Object>(this.sessionContext.defaultLoadingContext());
        }
        return this.loadingPlan;
    }

    private <I, E> PojoIndexedTypeIndexingPlan<I, E> createDelegate(PojoWorkIndexedTypeContext<I, E> typeContext) {
        return this.strategy.createDelegate(typeContext, this.sessionContext);
    }

    private PojoContainedTypeIndexingPlan<?, ?> createDelegate(PojoWorkContainedTypeContext<?, ?> typeContext) {
        return this.strategy.createDelegate(typeContext, this.sessionContext);
    }
}

