/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.DirtinessDescriptor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventPayload;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoIndexingQueueEventProcessingPlanImpl
implements PojoIndexingQueueEventProcessingPlan {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkIndexedTypeContextProvider indexedTypeContextProvider;
    private final PojoWorkContainedTypeContextProvider containedTypeContextProvider;
    private final PojoWorkSessionContext sessionContext;
    private final PojoIndexingPlan delegate;

    public PojoIndexingQueueEventProcessingPlanImpl(PojoWorkIndexedTypeContextProvider indexedTypeContextProvider, PojoWorkContainedTypeContextProvider containedTypeContextProvider, PojoWorkSessionContext sessionContext, PojoIndexingPlan delegate) {
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.containedTypeContextProvider = containedTypeContextProvider;
        this.sessionContext = sessionContext;
        this.delegate = delegate;
    }

    @Override
    public void append(String entityName, String serializedId, PojoIndexingQueueEventPayload payload) {
        PojoWorkTypeContext<?, ?> typeContext = this.typeContext(entityName);
        Object id = typeContext.identifierMapping().fromDocumentIdentifier(serializedId, this.sessionContext);
        DirtinessDescriptor dirtiness = payload.dirtiness;
        this.delegate.addOrUpdateOrDelete(typeContext.typeIdentifier(), id, payload.routes, dirtiness.updatedBecauseOfContained() || dirtiness.forceSelfDirty(), dirtiness.forceContainingDirty(), dirtiness.dirtyPaths() == null ? null : typeContext.pathOrdinals().toPathSelection(dirtiness.dirtyPaths()));
    }

    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory) {
        return this.delegate.executeAndReport(entityReferenceFactory);
    }

    @Override
    public <I> String toSerializedId(String entityName, I identifier) {
        IdentifierMappingImplementor<?, ?> identifierMapping = this.typeContext(entityName).identifierMapping();
        return identifierMapping.toDocumentIdentifier(identifier, this.sessionContext.mappingContext());
    }

    @Override
    public Object toIdentifier(String entityName, String serializedId) {
        PojoWorkTypeContext<?, ?> typeContext = this.typeContext(entityName);
        return typeContext.identifierMapping().fromDocumentIdentifier(serializedId, this.sessionContext);
    }

    private PojoWorkTypeContext<?, ?> typeContext(String entityName) {
        Optional<PojoWorkTypeContext<?, ?>> optional = this.indexedTypeContextProvider.forEntityName(entityName);
        if (!optional.isPresent() && !(optional = this.containedTypeContextProvider.forEntityName(entityName)).isPresent()) {
            throw log.nonIndexedTypeInIndexingEvent(entityName);
        }
        return optional.get();
    }
}

