/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanEventQueueDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanIndexDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

final class PojoTypeIndexingPlanIndexOrEventQueueDelegate<I, E>
implements PojoTypeIndexingPlanDelegate<I, E> {
    private final PojoWorkIndexedTypeContext<I, E> typeContext;
    private final PojoTypeIndexingPlanIndexDelegate<I, E> indexDelegate;
    private final PojoTypeIndexingPlanEventQueueDelegate<I, E> eventQueueDelegate;

    PojoTypeIndexingPlanIndexOrEventQueueDelegate(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, IndexIndexingPlan indexPlan, PojoIndexingQueueEventSendingPlan sendingPlan) {
        this.typeContext = typeContext;
        this.indexDelegate = new PojoTypeIndexingPlanIndexDelegate<I, E>(typeContext, sessionContext, indexPlan);
        this.eventQueueDelegate = new PojoTypeIndexingPlanEventQueueDelegate<I, E>(typeContext, sessionContext, sendingPlan);
    }

    @Override
    public boolean isDirtyForAddOrUpdate(boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPathsOrNull) {
        return forceSelfDirty || dirtyPathsOrNull != null && this.typeContext.dirtySelfFilter().test(dirtyPathsOrNull);
    }

    @Override
    public void add(I identifier, DocumentRouteDescriptor route, Supplier<E> entitySupplier) {
        this.indexDelegate.add(identifier, route, entitySupplier);
    }

    @Override
    public void addOrUpdate(I identifier, DocumentRoutesDescriptor routes, Supplier<E> entitySupplier, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths, boolean updatedBecauseOfContained, boolean updateBecauseOfDirty) {
        PojoTypeIndexingPlanDelegate<I, E> delegate = updatedBecauseOfContained && !updateBecauseOfDirty ? this.eventQueueDelegate : this.indexDelegate;
        delegate.addOrUpdate(identifier, routes, entitySupplier, forceSelfDirty, forceContainingDirty, dirtyPaths, updatedBecauseOfContained, updateBecauseOfDirty);
    }

    @Override
    public void delete(I identifier, DocumentRoutesDescriptor routes, Supplier<E> entitySupplier) {
        this.indexDelegate.delete(identifier, routes, entitySupplier);
    }

    @Override
    public void discard() {
        this.indexDelegate.discard();
    }

    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory) {
        return this.indexDelegate.executeAndReport(entityReferenceFactory);
    }
}

